package com.artfess.cqlt.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.time.LocalDate;

/**
 * 境外企业人员信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author lxk
 * @since 2023-02-10
 */
@Data
@TableName("QF_ENTERPRISE_USERS_INFO")
@ApiModel(value="QfEnterpriseUsersInfo对象", description="境外企业人员信息")
public class QfEnterpriseUsersInfo extends AutoFillModel<QfEnterpriseUsersInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "QfEnterpriseInfo.enterpriseId", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "企业id")
    @TableField("enterprise_id_")
    private String enterpriseId;

    @NotNull(message = "QfEnterpriseInfo.name", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "人员名称")
    @TableField("name_")
    private String name;


    @ApiModelProperty(value = "人员职务")
    @TableField("job_name_")
    private String jobName;

    @ApiModelProperty(value = "人员性别【字典】")
    @TableField("sex_")
    private String sex;

    @ApiModelProperty(value = "邮箱")
    @TableField("email_")
    private String email;

    @ApiModelProperty(value = "是否重要人员【字典】（0：不是，1：是）")
    @TableField("is_important_")
    private Integer isImportant;

    @ApiModelProperty(value = "在职状态【字典】（0：在职，1：已离职）")
    @TableField("status_")
    private String status;

    @ApiModelProperty(value = "离职时间")
    @TableField("leave_date_")
    private LocalDate leaveDate;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

}
