package com.artfess.cqlt.dao;

import com.artfess.cqlt.model.QfOperationNewOrdersD;
import com.artfess.cqlt.model.QfOperationSalesProductD;
import com.artfess.cqlt.model.QfOperationSalesProductM;
import com.artfess.cqlt.vo.OpReportRespVo;
import com.artfess.cqlt.vo.OpReportReqVo;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 运营--产品销售数据填报主表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-17
 */
public interface QfOperationSalesProductMDao extends BaseMapper<QfOperationSalesProductM> {

    List<QfOperationSalesProductD> data(@Param("vo") OpReportReqVo t);

    List<QfOperationNewOrdersD> newOrderData(@Param("vo") OpReportReqVo t);

    List<QfOperationSalesProductD> pIncomeData(@Param("vo") OpReportReqVo t);

    List<QfOperationSalesProductD> historyList(@Param("fillMonth") int fillMonth, @Param("fillYear") Integer fillYear);

    List<OpReportRespVo> yearData(@Param("vo") OpReportReqVo t);

    List<OpReportRespVo> yearCustomerData(@Param("vo") OpReportReqVo t);

    List<OpReportRespVo> yearProductData(@Param("vo") OpReportReqVo t);

    List<OpReportRespVo> yearProductDetail(@Param("vo") OpReportReqVo t);

    List<OpReportRespVo> monthAnalysis(@Param("vo")OpReportReqVo t);
}
