package com.artfess.cqlt.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.cqlt.manager.SysSubjectClassManager;
import com.artfess.cqlt.model.SysSubjectClass;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.poi.util.ExcelUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 主题/专题分类表（sys_subject_class） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-03-30
 */
@Slf4j
@RestController
@Api(tags = "主题/专题分类表")
@RequestMapping("/sys/subject/class/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class SysSubjectClassController extends BaseController<SysSubjectClassManager, SysSubjectClass> {

    @Override
    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) SysSubjectClass t) {
        boolean b = baseService.saveInfo(t);
        if(!b) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  SysSubjectClass t) {

        boolean b = baseService.updateInfo(t);
        if(!b) {
            return new CommonResult<String>(false, I18nUtil.getMessage("update.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    /**
     * @param file
     * @return
     */
    @ApiOperation(value = "主题/专题分类表导入")
    @PostMapping("/importExcel")
    public CommonResult<String> importExcel(@RequestParam("file") MultipartFile file) throws Exception {
        try {
            ExcelUtils<SysSubjectClass> excelUtil = new ExcelUtils<>(SysSubjectClass.class);
            List<SysSubjectClass> list = excelUtil.importExcel(null, file.getInputStream());
            boolean result = baseService.importExcel(list);
            if (!result) {
                throw new IllegalArgumentException(I18nUtil.getMessage("import.fail", LocaleContextHolder.getLocale()));
            }
            return new CommonResult<>();
        } catch (Exception e) {
            e.printStackTrace();
            throw new IllegalArgumentException(I18nUtil.getMessage("import.fail", LocaleContextHolder.getLocale()) + "," + e.getMessage());
        }
    }

    @GetMapping("/getTree/{targetId}")
    @ApiOperation("获取当前指标关联树")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取当前指标关联树")
    public CommonResult<String> getTree(@ApiParam(name="targetId", value="指标id") @PathVariable String targetId) {
        List<SysSubjectClass> list = baseService.getTree(targetId);
        return CommonResult.success(list, null);
    }

    @GetMapping("/getPatentTarget/{targetId}")
    @ApiOperation("获取当前指标父级指标")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取当前指标父级指标")
    public CommonResult<String> getPatentTarget(@ApiParam(name="targetId", value="指标id") @PathVariable String targetId) {
        List<SysSubjectClass> list = baseService.getPatentTarget(targetId);
        return CommonResult.success(list, null);
    }
}
