/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.jms;

import com.artfess.activemq.model.JmsMessage;
import com.artfess.application.jms.JmsHandler;
import com.artfess.application.service.TemplateService;
import com.artfess.base.context.BaseContext;
import com.artfess.base.jms.Notice;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.annotation.JmsListener;

public class JmsMessageConsumer {
    private static final Logger logger = LoggerFactory.getLogger(JmsMessageConsumer.class);
    private Map<String, JmsHandler> jmsHandlerMap = new HashMap<String, JmsHandler>();
    @Resource
    TemplateService templateService;
    @Resource
    BaseContext baseContext;

    public void setJmsHandList(List<JmsHandler> jmsHandList) {
        for (JmsHandler handler : jmsHandList) {
            this.jmsHandlerMap.put(handler.getType(), handler);
        }
    }

    @JmsListener(destination="${jms.queue.name:eipQueue}", containerFactory="jmsListenerContainerQueue")
    public void receiveQueue(Object model) {
        logger.debug("[JMS]: Queue message is :" + model.getClass().getName() + "---" + model);
        this.handlerJmsMessage(model);
    }

    private void handlerJmsMessage(Object source) {
        if (BeanUtils.isEmpty((Object)source)) {
            return;
        }
        if (source instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)source;
            try {
                Serializable object = objectMessage.getObject();
                if (BeanUtils.isEmpty((Object)object)) {
                    return;
                }
                if (object instanceof JmsMessage) {
                    JmsMessage jmsMessage = (JmsMessage)object;
                    if (StringUtil.isNotEmpty((String)jmsMessage.getTenantId())) {
                        this.baseContext.setTempTenantId(jmsMessage.getTenantId());
                    }
                    JmsHandler jmsHandler = this.jmsHandlerMap.get(jmsMessage.getType());
                    jmsHandler.send(jmsMessage);
                }
                if (object instanceof Notice) {
                    Notice notice = (Notice)object;
                    if (StringUtil.isNotEmpty((String)notice.getTenantId())) {
                        this.baseContext.setTempTenantId(notice.getTenantId());
                    }
                    this.templateService.sendNotice(notice);
                }
            }
            catch (JMSException e) {
                logger.error(e.getMessage());
            }
        }
    }
}

