package com.artfess.cqlt.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * 报表信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author 管理员
 * @since 2023-02-17
 */
@Data
@ApiModel(value="QfReportInfo对象", description="报表信息")
public class QfReportInfo extends AutoFillModel<QfReportInfo> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "QfReportInfo.tyep", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "报表类型")
    @TableField("tyep_")
    private Integer tyep;

    @NotNull(message = "QfReportInfo.name", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "报表名称")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "报表英文名称")
    @TableField("name_en_")
    private String nameEn;

    @NotNull(message = "QfReportInfo.business", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "所属业务")
    @TableField("business_")
    private String business;

    @NotNull(message = "QfReportInfo.fillRate", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "填报周期")
    @TableField("fill_rate_")
    private String fillRate;

    @ApiModelProperty(value = "报表地址/编码")
    @TableField("key_")
    private String key;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "发布状态")
    @TableField("flag_")
    private Integer flag;

    @ApiModelProperty(value = "删除标识字典")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "报表权限")
    @TableField(exist = false)
    private String authority;


}
