package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationSalesMDao;
import com.artfess.cqlt.manager.QfOperationSalesDManager;
import com.artfess.cqlt.manager.QfOperationSalesMManager;
import com.artfess.cqlt.model.QfOperationSalesD;
import com.artfess.cqlt.model.QfOperationSalesM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 运营--企业销售数据填报主表 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-02-17
 */
@Service
public class QfOperationSalesMManagerImpl extends BaseManagerImpl<QfOperationSalesMDao, QfOperationSalesM> implements QfOperationSalesMManager {

    @Autowired
    private QfOperationSalesDManager operationSalesDManager;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean insertInfo(QfOperationSalesM t) {
        QueryWrapper<QfOperationSalesM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        List<QfOperationSalesM> QfOperationSalesMS = this.baseMapper.selectList(queryWrapper);
        if (!CollectionUtils.isEmpty(QfOperationSalesMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.insert(t);
        if (insert > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(QfOperationSalesM t) {
        QueryWrapper<QfOperationSalesM> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("fill_year_", t.getFillYear());
        queryWrapper.eq("fill_month_", t.getFillMonth());
        queryWrapper.eq("report_id_", t.getReportId());
        queryWrapper.ne("id_", t.getId());
        List<QfOperationSalesM> QfOperationSalesMS = this.baseMapper.selectList(queryWrapper);
        if (!CollectionUtils.isEmpty(QfOperationSalesMS)) {
            throw new BaseException(I18nUtil.getMessage("QfOperationKpiM.repeat", LocaleContextHolder.getLocale()));
        }
        int insert = this.baseMapper.updateById(t);
        if (insert > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateStatus(QfOperationSalesM t) {
        QfOperationSalesM QfOperationSalesM = baseMapper.selectById(t.getId());
        if (null == QfOperationSalesM) {
            return false;
        }
        QfOperationSalesM.setStatus(QfOperationSalesM.getStatus() == 0 ? 1 : 0);
        int i = this.baseMapper.updateById(QfOperationSalesM);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean importExcel(List<QfOperationSalesD> list, String mainId) {
        QfOperationSalesM QfOperationSalesM = this.baseMapper.selectById(mainId);
        Assert.notNull(QfOperationSalesM, I18nUtil.getMessage("filldata.notExist", LocaleContextHolder.getLocale()));
        Assert.isTrue(!"1".equals(QfOperationSalesM.getStatus()),  I18nUtil.getMessage("data_operate", LocaleContextHolder.getLocale()));
        QueryWrapper<QfOperationSalesD> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("main_id_", mainId);
        operationSalesDManager.remove(queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(QfOperationSalesM.getFillDate());
        });
        boolean b = operationSalesDManager.saveBatch(list);
        return b;
    }
}
