package com.artfess.cqlt.controller;


import com.alibaba.fastjson.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.cqlt.manager.QfHrPersonDManager;
import com.artfess.cqlt.model.QfHrPersonD;
import com.artfess.cqlt.model.QfHrPersonM;
import com.artfess.i18n.util.I18nUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import netscape.javascript.JSObject;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * 人资--人员数据填报详情表 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-02-27
 */
@Slf4j
@RestController
@Api(tags = "人资--人员数据填报详情表")
@RequestMapping("/qf/hr/person/detail/")
@ApiGroup(group = {ApiGroupConsts.GROUP_BIZ})
public class QfHrPersonDController extends BaseController<QfHrPersonDManager, QfHrPersonD> {

    @PostMapping("/batchSave")
    @ApiOperation("批量添加实体的接口")
    public CommonResult<String> batchSave(@ApiParam(name = "model", value = "实体信息") @RequestBody QfHrPersonM t) {
        boolean result = baseService.batchSave(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }

        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PutMapping("/batchUpdate")
    @ApiOperation("批量更新实体")
    public CommonResult<String> batchUpdate(@ApiParam(name = "model", value = "实体信息") @RequestBody QfHrPersonM t) {
        boolean result = baseService.batchUpdate(t);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("option.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }


    @Override
    @DeleteMapping("/{id}")
    @ApiOperation("根据id删除")
    public CommonResult<String> deleteById(@ApiParam(name = "id", value = "实体id") @PathVariable String id) {
        boolean result = baseService.removeById(id);
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @Override
    @DeleteMapping("/")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result = baseService.removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<String>(false, I18nUtil.getMessage("delete.fail", LocaleContextHolder.getLocale()), null);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }

    @PostMapping(value="/detailQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("获取详情数据")
    public CommonResult detailQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<QfHrPersonD> queryFilter) {
        PageList<QfHrPersonD> pageList = baseService.query(queryFilter);
        List<JSONObject> list = baseService.detailQuery(pageList.getRows());
        return CommonResult.success(list, null);
    }

}
