/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.enums.ContinentEnum;
import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CollectionUtils;
import com.artfess.cqlt.dao.QfEnterpriseInfoDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.vo.EnterpriseInfoVo;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;

@Service
public class QfEnterpriseInfoManagerImpl
extends BaseManagerImpl<QfEnterpriseInfoDao, QfEnterpriseInfo>
implements QfEnterpriseInfoManager {
    @Autowired
    private QfFinancialStatisticalManager qfFinancialStatisticalManager;

    @Override
    public CommonResult insertInfo(QfEnterpriseInfo info) {
        if (((QfEnterpriseInfoDao)this.baseMapper).insert((Object)info) > 0) {
            return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), (Object)info.getId());
        }
        return new CommonResult(false, I18nUtil.getMessage((String)"option.fail", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @Override
    public CommonResult updateInfoById(QfEnterpriseInfo info) {
        if (StringUtils.isEmpty((CharSequence)info.getId())) {
            return new CommonResult(false, I18nUtil.getMessage((String)"parameter.error", (Locale)LocaleContextHolder.getLocale()), null);
        }
        if (((QfEnterpriseInfoDao)this.baseMapper).updateById((Object)info) > 0) {
            return new CommonResult(true, I18nUtil.getMessage((String)"update.success", (Locale)LocaleContextHolder.getLocale()), (Object)info.getId());
        }
        return new CommonResult(false, I18nUtil.getMessage((String)"update.fail", (Locale)LocaleContextHolder.getLocale()), null);
    }

    @Override
    public CommonResult<List<QfEnterpriseInfo>> getTree() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List allList = ((QfEnterpriseInfoDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (allList.size() <= 0) {
            return new CommonResult(false, I18nUtil.getMessage((String)"data.empty", (Locale)LocaleContextHolder.getLocale()), null);
        }
        List treeList = BeanUtils.listToTree((List)allList);
        return new CommonResult(true, I18nUtil.getMessage((String)"option.success", (Locale)LocaleContextHolder.getLocale()), (Object)treeList);
    }

    @Override
    public Map<String, QfEnterpriseInfo> getEnterpriseInfoMap(QfEnterpriseInfo info) {
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        List enterpriseInfoList = ((QfEnterpriseInfoDao)this.baseMapper).selectList((Wrapper)enterpriseInfoQuery);
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = enterpriseInfoList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        return enterpriseInfoMap;
    }

    @Override
    public List<EnterpriseInfoVo> getAreaTree(QueryFilter<QfEnterpriseInfo> queryFilter) {
        PageList query = this.query(queryFilter);
        List allList = query.getRows();
        if (CollectionUtils.isEmpty((Collection)allList)) {
            return Lists.newArrayList();
        }
        Map<String, List<QfEnterpriseInfo>> map = allList.stream().filter(b -> !StringUtils.isEmpty((CharSequence)b.getContinent())).collect(Collectors.groupingBy(QfEnterpriseInfo::getContinent));
        ArrayList list = Lists.newArrayList();
        QfEnterpriseInfo group = this.getGroup();
        allList.forEach(info -> {
            if (info.getCode().equals(group.getCode())) {
                EnterpriseInfoVo infoVo = new EnterpriseInfoVo();
                infoVo.setContinent(ContinentEnum.getDesc((String)ContinentEnum.Group.getType()));
                ArrayList infoVos = Lists.newArrayList();
                EnterpriseInfoVo sggrVo = new EnterpriseInfoVo();
                sggrVo.setCode(group.getCode());
                sggrVo.setName(group.getName());
                sggrVo.setId(group.getId());
                infoVos.add(sggrVo);
                infoVo.setList(infoVos);
                list.add(infoVo);
            }
        });
        map.forEach((k, v) -> {
            EnterpriseInfoVo enterpriseInfoVo = new EnterpriseInfoVo();
            enterpriseInfoVo.setContinent(ContinentEnum.getDesc((String)k));
            ArrayList enterpriseInfoVos = Lists.newArrayList();
            v.forEach(enterpriseInfo -> {
                EnterpriseInfoVo vo = new EnterpriseInfoVo();
                vo.setId(enterpriseInfo.getId());
                vo.setCode(enterpriseInfo.getCode());
                vo.setName(enterpriseInfo.getName());
                enterpriseInfoVos.add(vo);
            });
            enterpriseInfoVo.setList(enterpriseInfoVos);
            list.add(enterpriseInfoVo);
        });
        return list;
    }

    @Override
    public QfEnterpriseInfo findByCode(String code) {
        BigDecimal lastYearProfitsSales;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code_", (Object)code);
        QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((QfEnterpriseInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        int lastYear = LocalDate.now().getYear() - 1;
        String salesCode = "FE009";
        String profitsSalesCode = "FE001";
        BigDecimal lastYearSales = this.qfFinancialStatisticalManager.getLastYearSales(lastYear, salesCode, code);
        if (null != lastYearSales) {
            lastYearSales = lastYearSales.divide(new BigDecimal(10000), 2, 4);
            qfEnterpriseInfo.setLastYearSales(lastYearSales + "\u4e07\u6b27");
        }
        if (null != (lastYearProfitsSales = this.qfFinancialStatisticalManager.getlastYearProfitsSales(lastYear, profitsSalesCode, code))) {
            lastYearProfitsSales = lastYearProfitsSales.divide(new BigDecimal(10000), 2, 4);
            qfEnterpriseInfo.setLastProfitsSales(lastYearProfitsSales + "\u4e07\u6b27");
        }
        return qfEnterpriseInfo;
    }

    @Override
    public QfEnterpriseInfo getGroup() {
        QueryWrapper enterpriseInfoQuery = new QueryWrapper();
        enterpriseInfoQuery.eq((Object)"IS_DELE_", (Object)DelStatusEnum.N.getType());
        enterpriseInfoQuery.eq((Object)"TYPE_", (Object)0);
        QfEnterpriseInfo enterpriseInfo = (QfEnterpriseInfo)((Object)((QfEnterpriseInfoDao)this.baseMapper).selectOne((Wrapper)enterpriseInfoQuery));
        return enterpriseInfo;
    }
}

