/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.artfess.base.enums.AnalyseTypeEnum;
import com.artfess.base.enums.FaTargetTypeEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.CommonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cqlt.dao.QfFinancialStatisticalDao;
import com.artfess.cqlt.manager.QfEnterpriseInfoManager;
import com.artfess.cqlt.manager.QfEuroRatesDManager;
import com.artfess.cqlt.manager.QfFinanceLoanDManager;
import com.artfess.cqlt.manager.QfFinancePlSManager;
import com.artfess.cqlt.manager.QfFinancialStatisticalManager;
import com.artfess.cqlt.manager.QfHrPersonMManager;
import com.artfess.cqlt.manager.SysSubjectTargetManager;
import com.artfess.cqlt.model.QfEnterpriseInfo;
import com.artfess.cqlt.model.QfFinancialStatistical;
import com.artfess.cqlt.model.SysSubjectTarget;
import com.artfess.cqlt.utils.FinancialTimeUtils;
import com.artfess.cqlt.vo.BankLoanDetailRespVo;
import com.artfess.cqlt.vo.BridgeFigureVo;
import com.artfess.cqlt.vo.DataInfoVo;
import com.artfess.cqlt.vo.DateReqVo;
import com.artfess.cqlt.vo.EuroRatesRespVo;
import com.artfess.cqlt.vo.FaReportRespVo;
import com.artfess.cqlt.vo.FaTargetRespVo;
import com.artfess.cqlt.vo.ReportReqVo;
import com.artfess.cqlt.vo.ReportVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class QfFinancialStatisticalManagerImpl
extends BaseManagerImpl<QfFinancialStatisticalDao, QfFinancialStatistical>
implements QfFinancialStatisticalManager {
    private static final Logger log = LoggerFactory.getLogger(QfFinancialStatisticalManagerImpl.class);
    private Map<String, QfEnterpriseInfo> enterpriseInfoMap = Maps.newHashMap();
    private FinancialTimeUtils financialTimeUtils = new FinancialTimeUtils();
    private static final String HR_030000S = "HR030000s";
    private static final String PRODUCT_SALES_REVENUE = "FE029";
    private static final String PL_3000 = "UPL3000";
    private static final Integer BUDGET_TYPE = 2;
    private static final Integer ACTUAL_TYPE = 1;
    private static final Integer CIGR_TYPE = 2;
    private static final Integer COMPANY_TYPE = 1;
    @Autowired
    private SysSubjectTargetManager sysSubjectTargetManager;
    @Autowired
    private QfEnterpriseInfoManager enterpriseInfoManager;
    @Autowired
    private QfHrPersonMManager hrPersonmManager;
    @Autowired
    private QfFinancePlSManager plsManager;
    @Autowired
    private QfFinanceLoanDManager loandManager;
    @Autowired
    private QfEuroRatesDManager euroRatesdManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveData(List<ReportVo> list, DataInfoVo dataInfoVo, Integer dataType) {
        dataInfoVo.setDataType(dataType);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        ArrayList businessList = Lists.newArrayList();
        businessList.add("Finance");
        businessList.add("money");
        List<SysSubjectTarget> targetList = this.sysSubjectTargetManager.getTargetList(businessList);
        if (CollectionUtils.isEmpty(targetList)) {
            return false;
        }
        if (!dataInfoVo.getFlag().booleanValue()) {
            List<ReportVo> hrReportVo = this.hrPersonmManager.getHrReportVo(dataInfoVo, HR_030000S);
            list.addAll(hrReportVo);
        }
        Map<String, QfEnterpriseInfo> enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        ArrayList dataList = Lists.newArrayList();
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)dataInfoVo.getYear());
        query.eq((Object)"quarter_", (Object)dataInfoVo.getQuarter());
        query.eq((Object)"month_", (Object)dataInfoVo.getMonth());
        List qfFinancialStatisticals = ((QfFinancialStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        try {
            if (CollectionUtils.isEmpty((Collection)qfFinancialStatisticals)) {
                targetList.forEach(target -> this.saveFinancialStatistical((SysSubjectTarget)((Object)target), dataList, list, dataType, dataInfoVo, enterpriseInfoMap));
            } else {
                Map<String, List<QfFinancialStatistical>> statisticalMap = qfFinancialStatisticals.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getTargetId));
                targetList.forEach(target -> {
                    List statisticalList = Lists.newArrayList();
                    if (statisticalMap.containsKey(target.getId())) {
                        statisticalList = (List)statisticalMap.get(target.getId());
                    }
                    this.updateFinancialStatistical((SysSubjectTarget)((Object)target), dataList, statisticalList, list, dataType, dataInfoVo, enterpriseInfoMap);
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        List<QfFinancialStatistical> lastYearData = this.lastYearData(dataInfoVo);
        this.processSalesRevenue(dataList, targetList, dataInfoVo, lastYearData);
        try {
            this.partitionSave(dataList);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8d22\u52a1\u5927\u5c4f\u62a5\u8868\u5b9e\u9645\u6570\u636e\u751f\u6210\u5931\u8d25:{}", (Object)e.getMessage());
            return false;
        }
    }

    private void processSalesRevenue(List<QfFinancialStatistical> dataList, List<SysSubjectTarget> targetList, DataInfoVo dataInfoVo, List<QfFinancialStatistical> lastYearDate) {
        Map<String, SysSubjectTarget> subjectTargetMap = targetList.stream().collect(Collectors.toMap(item -> item.getCode(), item -> item));
        String salesRevenueTargetId = null;
        if (subjectTargetMap.containsKey(PRODUCT_SALES_REVENUE)) {
            salesRevenueTargetId = subjectTargetMap.get(PRODUCT_SALES_REVENUE).getId();
        }
        ArrayList list = Lists.newArrayList();
        String finalSalesRevenueTargetId = salesRevenueTargetId;
        dataList.forEach(detail -> {
            if (finalSalesRevenueTargetId.equals(detail.getTargetId()) && null != detail.getEnterpriseArea()) {
                detail.setAnalyseType(detail.getEnterpriseArea() + "");
                list.add(detail);
            }
            if (AnalyseTypeEnum.mergeType().contains(detail.getAnalyseType())) {
                list.add(detail);
            }
        });
        Map<String, List<QfFinancialStatistical>> statisticalMap = list.stream().filter(b -> !StringUtils.isEmpty((Object)b.getAnalyseType())).collect(Collectors.groupingBy(QfFinancialStatistical::getAnalyseType));
        Map<String, List<SysSubjectTarget>> targetMap = targetList.stream().filter(b -> !StringUtils.isEmpty((Object)b.getAnalyseType())).collect(Collectors.groupingBy(SysSubjectTarget::getAnalyseType));
        if (!CollectionUtils.isEmpty(lastYearDate)) {
            this.calculatingBalance(dataInfoVo, lastYearDate, statisticalMap);
            this.calculatingAverage(dataInfoVo, lastYearDate, statisticalMap);
        }
        List<QfFinancialStatistical> areaData = this.getAreaData(dataInfoVo);
        Map<String, QfFinancialStatistical> areaTargetMap = areaData.stream().collect(Collectors.toMap(item -> item.getTargetId(), item -> item));
        targetMap.forEach((analyseType, v) -> {
            List statisticals = (List)statisticalMap.get(analyseType);
            if (CollectionUtils.isEmpty((Collection)statisticals)) {
                return;
            }
            this.calculatingArea(dataList, dataInfoVo, areaTargetMap, (String)analyseType, (List<SysSubjectTarget>)v, statisticals);
        });
    }

    private void calculatingAverage(DataInfoVo dataInfoVo, List<QfFinancialStatistical> lastYearDate, Map<String, List<QfFinancialStatistical>> statisticalMap) {
        if (CollectionUtils.isEmpty(statisticalMap)) {
            return;
        }
        ArrayList statisticals = Lists.newArrayList();
        if (statisticalMap.containsKey(AnalyseTypeEnum.JLR.getType())) {
            statisticals.addAll((Collection)statisticalMap.get(AnalyseTypeEnum.JLR.getType()));
        }
        if (statisticalMap.containsKey(AnalyseTypeEnum.XSSR.getType())) {
            statisticals.addAll((Collection)statisticalMap.get(AnalyseTypeEnum.XSSR.getType()));
        }
        if (statisticalMap.containsKey(AnalyseTypeEnum.XSCB.getType())) {
            statisticals.addAll((Collection)statisticalMap.get(AnalyseTypeEnum.XSCB.getType()));
        }
        if (statisticalMap.containsKey(AnalyseTypeEnum.PJZCZE.getType())) {
            statisticals.addAll((Collection)statisticalMap.get(AnalyseTypeEnum.PJZCZE.getType()));
        }
        if (CollectionUtils.isEmpty((Collection)statisticals)) {
            return;
        }
        statisticals.forEach(thisYearData -> {
            if (StringUtils.isEmpty((Object)thisYearData.getTargetCalculation())) {
                return;
            }
            AnalyseTypeEnum analyse = AnalyseTypeEnum.getAnalyse((String)thisYearData.getAnalyseType());
            lastYearDate.forEach(lastYearData -> {
                BigDecimal value;
                BigDecimal lastYearValue;
                BigDecimal thisYearValue;
                if (StringUtils.isEmpty((Object)thisYearData.getTargetCalculation()) || !lastYearData.getTargetId().equals(thisYearData.getTargetId()) || !lastYearData.getEnterpriseCode().equals(thisYearData.getEnterpriseCode())) {
                    return;
                }
                Map thisYearCalculationMap = (Map)JSONObject.parseObject((String)thisYearData.getTargetCalculation(), Map.class);
                Map thisYearYtdCalculationMap = (Map)JSONObject.parseObject((String)thisYearData.getYtdTargetCalculation(), Map.class);
                Map lastYearCalculationMap = (Map)JSONObject.parseObject((String)lastYearData.getTargetCalculation(), Map.class);
                Map lastYearYtdCalculationMap = (Map)JSONObject.parseObject((String)lastYearData.getYtdTargetCalculation(), Map.class);
                Map thisYearDataMap = (Map)thisYearCalculationMap.get(dataInfoVo.getDataType());
                Map thisYearYtdDataMap = (Map)thisYearYtdCalculationMap.get(dataInfoVo.getDataType());
                Map lastYearDataMap = (Map)lastYearCalculationMap.get(dataInfoVo.getDataType());
                Map lastYearYtdDataMap = (Map)lastYearYtdCalculationMap.get(dataInfoVo.getDataType());
                if (CollectionUtils.isEmpty((Map)thisYearDataMap) || CollectionUtils.isEmpty((Map)lastYearDataMap)) {
                    return;
                }
                String divisorCalculation = analyse.getFormula();
                List divisorExpressionKey = CommonUtil.getExpressionKey((String)divisorCalculation);
                String thisYearDivisorCalculation = CommonUtil.replaceExpression((List)divisorExpressionKey, (String)divisorCalculation);
                BigDecimal divisorValue = CommonUtil.convertToCode((String)thisYearDivisorCalculation, (Map)thisYearDataMap, (int)4);
                String targetCalculation = thisYearData.getTempCalculation().replaceAll(analyse.getFormula() + "/", "");
                List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
                String thisCalculation = CommonUtil.replaceExpression((List)expressionKey, (String)targetCalculation);
                if (expressionKey.size() <= thisYearDataMap.size() && expressionKey.size() <= thisYearDataMap.size()) {
                    thisYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)thisYearDataMap, (int)4);
                    lastYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)lastYearDataMap, (int)4);
                    value = this.getAvgValue((QfFinancialStatistical)((Object)thisYearData), (QfFinancialStatistical)((Object)((Object)lastYearData)), divisorValue, thisYearValue, lastYearValue, 4);
                    if (dataInfoVo.getDataType() == 1) {
                        thisYearData.setActual(value);
                    } else if (BUDGET_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setBudget(value);
                    }
                }
                if (expressionKey.size() <= thisYearYtdDataMap.size() && expressionKey.size() <= thisYearYtdDataMap.size()) {
                    thisYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)thisYearYtdDataMap, (int)2);
                    lastYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)lastYearYtdDataMap, (int)2);
                    divisorValue = CommonUtil.convertToCode((String)thisYearDivisorCalculation, (Map)thisYearYtdDataMap, (int)4);
                    value = this.getAvgValue((QfFinancialStatistical)((Object)thisYearData), (QfFinancialStatistical)((Object)((Object)lastYearData)), divisorValue, thisYearValue, lastYearValue, 4);
                    if (ACTUAL_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setActualYtd(value);
                    } else if (BUDGET_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setBudgetYtd(value);
                    }
                }
                log.info("\u6700\u7ec8\u8ba1\u7b97\u6570\u636e:thisYearData\uff1a{}", (Object)JSON.toJSONString((Object)thisYearData));
            });
        });
    }

    private BigDecimal getAvgValue(QfFinancialStatistical thisYearData, QfFinancialStatistical lastYearData, BigDecimal divisorValue, BigDecimal thisYearValue, BigDecimal lastYearValue, int i) {
        BigDecimal value = null;
        value = null != lastYearData ? thisYearValue.add(lastYearValue).divide(new BigDecimal(2), 4, 4) : thisYearValue;
        value = null == value || value.doubleValue() == 0.0 ? BigDecimal.ZERO : divisorValue.divide(value, 4, 4);
        if ("\u5929".equals(thisYearData.getTargetUnit()) && value.doubleValue() > 0.0) {
            value = new BigDecimal(30).multiply(new BigDecimal(thisYearData.getMonth())).divide(value, i, 4);
        }
        if ("\u6b21".equals(thisYearData.getTargetUnit()) && !AnalyseTypeEnum.PJZCZE.getType().equals(thisYearData.getAnalyseType())) {
            value = value.multiply(new BigDecimal(100));
        }
        if ("%".equals(thisYearData.getTargetUnit())) {
            value = value.multiply(new BigDecimal(100));
        }
        return value;
    }

    private void calculatingArea(List<QfFinancialStatistical> dataList, DataInfoVo dataInfoVo, Map<String, QfFinancialStatistical> areaTargetMap, String analyseType, List<SysSubjectTarget> v, List<QfFinancialStatistical> statisticals) {
        if (AnalyseTypeEnum.getAreaType().contains(analyseType)) {
            BigDecimal actual = BigDecimal.ZERO;
            BigDecimal budget = BigDecimal.ZERO;
            BigDecimal actualYtd = BigDecimal.ZERO;
            BigDecimal budgetYtd = BigDecimal.ZERO;
            for (QfFinancialStatistical qfFinancialStatistical : statisticals) {
                String targetCalculation = qfFinancialStatistical.getTargetCalculation();
                String ytdTargetCalculation = qfFinancialStatistical.getYtdTargetCalculation();
                Map map = (Map)JSONObject.parseObject((String)targetCalculation, Map.class);
                Map ytdMap = (Map)JSONObject.parseObject((String)ytdTargetCalculation, Map.class);
                JSONObject actualMap = (JSONObject)map.get(ACTUAL_TYPE);
                JSONObject budgetMap = (JSONObject)map.get(BUDGET_TYPE);
                JSONObject actualYtdMap = (JSONObject)ytdMap.get(ACTUAL_TYPE);
                JSONObject budgetYtdMap = (JSONObject)ytdMap.get(BUDGET_TYPE);
                if (!CollectionUtils.isEmpty((Map)actualMap)) {
                    actual = actual.add(null == actualMap.getBigDecimal(PL_3000) ? BigDecimal.ZERO : actualMap.getBigDecimal(PL_3000));
                }
                if (!CollectionUtils.isEmpty((Map)budgetMap)) {
                    budget = budget.add(null == budgetMap.getBigDecimal(PL_3000) ? BigDecimal.ZERO : budgetMap.getBigDecimal(PL_3000));
                }
                if (!CollectionUtils.isEmpty((Map)actualYtdMap)) {
                    actualYtd = actualYtd.add(null == actualYtdMap.getBigDecimal(PL_3000) ? BigDecimal.ZERO : actualYtdMap.getBigDecimal(PL_3000));
                }
                if (CollectionUtils.isEmpty((Map)budgetYtdMap)) continue;
                budgetYtd = budgetYtd.add(null == budgetYtdMap.getBigDecimal(PL_3000) ? BigDecimal.ZERO : budgetYtdMap.getBigDecimal(PL_3000));
            }
            BigDecimal finalActual = actual;
            BigDecimal finalBudget = budget;
            BigDecimal finalBudgetYtd = budgetYtd;
            BigDecimal finalActualYtd = actualYtd;
            v.forEach(target -> {
                QfFinancialStatistical qfFinancialStatistical = null;
                if (areaTargetMap.containsKey(target.getId())) {
                    qfFinancialStatistical = (QfFinancialStatistical)((Object)((Object)areaTargetMap.get(target.getId())));
                } else {
                    qfFinancialStatistical = new QfFinancialStatistical();
                    this.createInfo((SysSubjectTarget)((Object)target), dataInfoVo, qfFinancialStatistical);
                    qfFinancialStatistical.setEnterpriseCode("CIGR");
                }
                qfFinancialStatistical.setActual(finalActual);
                qfFinancialStatistical.setActualYtd(finalActualYtd);
                qfFinancialStatistical.setBudget(finalBudget);
                qfFinancialStatistical.setBudgetYtd(finalBudgetYtd);
                dataList.add(qfFinancialStatistical);
            });
        }
    }

    private void calculatingBalance(DataInfoVo dataInfoVo, List<QfFinancialStatistical> lastYearDate, Map<String, List<QfFinancialStatistical>> statisticalMap) {
        List<QfFinancialStatistical> statisticals = statisticalMap.get(AnalyseTypeEnum.NCYE.getType());
        if (CollectionUtils.isEmpty(statisticals)) {
            return;
        }
        statisticals.forEach(thisYearData -> {
            if (StringUtils.isEmpty((Object)thisYearData.getTargetCalculation())) {
                return;
            }
            lastYearDate.forEach(lastYearData -> {
                BigDecimal value;
                BigDecimal lastYearValue;
                BigDecimal thisYearValue;
                if (StringUtils.isEmpty((Object)thisYearData.getTargetCalculation())) {
                    return;
                }
                if (!lastYearData.getTargetId().equals(thisYearData.getTargetId())) {
                    return;
                }
                if (!lastYearData.getEnterpriseCode().equals(thisYearData.getEnterpriseCode())) {
                    return;
                }
                Map lastYearCalculationMap = (Map)JSONObject.parseObject((String)lastYearData.getTargetCalculation(), Map.class);
                Map thisYearCalculationMap = (Map)JSONObject.parseObject((String)thisYearData.getTargetCalculation(), Map.class);
                Map lastYearYtdCalculationMap = (Map)JSONObject.parseObject((String)lastYearData.getYtdTargetCalculation(), Map.class);
                Map thisYearYtdCalculationMap = (Map)JSONObject.parseObject((String)thisYearData.getYtdTargetCalculation(), Map.class);
                Map thisYearDataMap = (Map)thisYearCalculationMap.get(dataInfoVo.getDataType());
                Map lastYearDataMap = (Map)lastYearCalculationMap.get(dataInfoVo.getDataType());
                Map thisYearYtdDataMap = (Map)thisYearYtdCalculationMap.get(dataInfoVo.getDataType());
                Map lastYearYtdDataMap = (Map)lastYearYtdCalculationMap.get(dataInfoVo.getDataType());
                if (CollectionUtils.isEmpty((Map)thisYearDataMap) || CollectionUtils.isEmpty((Map)lastYearDataMap)) {
                    return;
                }
                String targetCalculation = thisYearData.getTempCalculation();
                List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
                String thisCalculation = CommonUtil.replaceExpression((List)expressionKey, (String)targetCalculation);
                if (expressionKey.size() == thisYearDataMap.size() && expressionKey.size() == thisYearDataMap.size()) {
                    thisYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)thisYearDataMap, (int)2);
                    lastYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)lastYearDataMap, (int)2);
                    value = BigDecimal.ZERO;
                    if (null != lastYearValue && lastYearValue.doubleValue() != 0.0) {
                        value = thisYearValue.divide(lastYearValue, 4, 4).multiply(new BigDecimal(100));
                    }
                    if (ACTUAL_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setActual(value);
                    } else if (BUDGET_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setBudget(value);
                    }
                }
                if (expressionKey.size() == thisYearYtdDataMap.size() && expressionKey.size() == thisYearYtdDataMap.size()) {
                    thisYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)thisYearYtdDataMap, (int)2);
                    lastYearValue = CommonUtil.convertToCode((String)thisCalculation, (Map)lastYearYtdDataMap, (int)2);
                    value = BigDecimal.ZERO;
                    if (null != lastYearValue && lastYearValue.doubleValue() != 0.0) {
                        value = thisYearValue.divide(lastYearValue, 4, 4).multiply(new BigDecimal(100));
                    }
                    if (ACTUAL_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setActualYtd(value);
                    } else if (BUDGET_TYPE.equals(dataInfoVo.getDataType())) {
                        thisYearData.setBudgetYtd(value);
                    }
                }
            });
        });
    }

    private List<QfFinancialStatistical> getAreaData(DataInfoVo dataInfoVo) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)dataInfoVo.getYear());
        query.eq((Object)"month_", (Object)dataInfoVo.getMonth());
        query.eq((Object)"target_level_", (Object)4);
        query.in((Object)"analyse_type_", (Collection)AnalyseTypeEnum.getAreaType());
        List qfFinancialStatisticals = ((QfFinancialStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        return qfFinancialStatisticals;
    }

    private List<QfFinancialStatistical> lastYearData(DataInfoVo dataInfoVo) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"year_", (Object)(dataInfoVo.getYear() - 1));
        query.eq((Object)"month_", (Object)12);
        query.in((Object)"analyse_type_", (Collection)AnalyseTypeEnum.mergeType());
        List qfFinancialStatisticals = ((QfFinancialStatisticalDao)this.baseMapper).selectList((Wrapper)query);
        return qfFinancialStatisticals;
    }

    @Override
    public List<FaTargetRespVo> data(ReportReqVo t) {
        if (StringUtils.isEmpty((Object)t.getTargetId())) {
            t.setTargetLevel("1");
        }
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        if (StringUtil.isEmpty((String)t.getEnterpriseCode()) || group.getCode().equals(t.getEnterpriseCode())) {
            t.setEnterpriseCode(group.getCode());
            t.setType(2);
        } else {
            t.setType(1);
        }
        List<SysSubjectTarget> targetList = ((QfFinancialStatisticalDao)this.baseMapper).getGroupData(t);
        ArrayList resultList = Lists.newArrayList();
        targetList.forEach(target -> {
            List<FaReportRespVo> resultData;
            String[] type = new String[]{"5"};
            List<String> newTypeList = Arrays.asList(type);
            t.setTargetId(target.getId());
            List<FaTargetRespVo> faTargetRespVos = this.currentTargetAnalysis((SysSubjectTarget)((Object)target), newTypeList, t, null, true);
            resultList.addAll(faTargetRespVos);
            FaTargetRespVo resultFa = new FaTargetRespVo();
            resultFa.setTargetId(target.getId());
            resultFa.setTargetName(target.getName());
            resultFa.setTargetNameEn(target.getTargetNameEn());
            resultFa.setTargetUnit(target.getUnit());
            if ("1".equals(target.getConversionUnit())) {
                resultFa.setTargetUnit("10K\u20ac");
            }
            if ("2".equals(target.getConversionUnit())) {
                resultFa.setTargetUnit("\u4ebf\u6b27");
            }
            if ("\u4e07\u6b27/\u4eba".equals(target.getUnit())) {
                resultFa.setTargetUnit("10K\u20ac/person");
            }
            if ("\u4eba".equals(target.getUnit())) {
                resultFa.setTargetUnit("person");
            }
            resultFa.setStaLat("3");
            resultFa.setType("13");
            resultFa.setSn(target.getSn());
            if (!CollectionUtils.isEmpty(faTargetRespVos) && !CollectionUtils.isEmpty(resultData = faTargetRespVos.get(0).getResultData())) {
                FaReportRespVo faReportRespVo = resultData.get(resultData.size() - 1);
                resultFa.setShowValue(faReportRespVo.getActual());
                resultFa.setAsDate(faReportRespVo.getYear() + "-" + faReportRespVo.getMonth());
            }
            resultList.add(resultFa);
        });
        return resultList;
    }

    @Override
    public List<FaTargetRespVo> dataAnalysis(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        SysSubjectTarget target = (SysSubjectTarget)this.sysSubjectTargetManager.get((Serializable)((Object)t.getTargetId()));
        Assert.notNull((Object)((Object)target), (String)"\u5f53\u524d\u6307\u6807\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)target.getType())) {
            return Lists.newArrayList();
        }
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        if (StringUtil.isEmpty((String)t.getEnterpriseCode()) || group.getCode().equals(t.getEnterpriseCode())) {
            t.setEnterpriseCode(group.getCode());
            t.setType(2);
        } else {
            t.setType(1);
        }
        List<String> typeList = Arrays.asList(target.getType().split(","));
        ArrayList newTypeList = Lists.newArrayList();
        for (int i = 0; i < typeList.size(); ++i) {
            if (i <= 2) continue;
            newTypeList.add(typeList.get(i));
        }
        List<Object> lowerLevelTargetList = Lists.newArrayList();
        if (target.getType().contains("11")) {
            lowerLevelTargetList = this.sysSubjectTargetManager.lowerLevelTargetList(target.getSubjectId());
        }
        List<FaTargetRespVo> list = this.currentTargetAnalysis(target, newTypeList, t, lowerLevelTargetList, false);
        return list;
    }

    @Override
    public BigDecimal getLastYearSales(int lastYear, String salesCode, String code) {
        return ((QfFinancialStatisticalDao)this.baseMapper).findByTargetCodeAndCompanyCode(lastYear, salesCode, code);
    }

    @Override
    public BigDecimal getlastYearProfitsSales(int lastYear, String profitsSalesCode, String code) {
        return ((QfFinancialStatisticalDao)this.baseMapper).findByTargetCodeAndCompanyCode(lastYear, profitsSalesCode, code);
    }

    @Override
    public List<FaTargetRespVo> moneyData(ReportReqVo t) {
        if (StringUtils.isEmpty((Object)t.getTargetId())) {
            t.setTargetLevel("1");
        }
        if (null == t.getYear() || t.getYear() <= 0) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        if (null == t.getStartYear() || null == t.getEndYear()) {
            t.setEndYear(t.getYear());
            t.setStartYear(t.getYear() - 5);
        }
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        if (StringUtil.isEmpty((String)t.getEnterpriseCode()) || group.getCode().equals(t.getEnterpriseCode())) {
            t.setEnterpriseCode(group.getCode());
            t.setType(2);
        } else {
            t.setType(1);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"target_level_", (Object)"1");
        queryWrapper.eq((Object)"business_", (Object)"money");
        List targetList = this.sysSubjectTargetManager.list((Wrapper)queryWrapper);
        ArrayList resultList = Lists.newArrayList();
        targetList.forEach(target -> {
            String[] type = new String[]{"5"};
            List<String> newTypeList = Arrays.asList(type);
            t.setTargetId(target.getId());
            List<FaTargetRespVo> faTargetRespVos = this.currentTargetAnalysis((SysSubjectTarget)((Object)target), newTypeList, t, null, true);
            resultList.addAll(faTargetRespVos);
        });
        return resultList;
    }

    @Override
    public List<FaTargetRespVo> bridgeFigureAnalysis(ReportReqVo t) {
        SysSubjectTarget target = (SysSubjectTarget)this.sysSubjectTargetManager.get((Serializable)((Object)t.getTargetId()));
        if (null == target) {
            return null;
        }
        String[] targetCodes = null;
        if ("FE001".equals(target.getCode())) {
            targetCodes = new String[]{"FE013", "FE912", "FE012", "FE011", "FE034", "FE033", "FE032", "FE031", "FE030", PRODUCT_SALES_REVENUE, "FE001"};
        } else if ("FE040".equals(target.getCode())) {
            targetCodes = new String[]{"FE011", "FE034", "FE033", "FE032", "FE031", "FE030", PRODUCT_SALES_REVENUE, "FE040"};
        }
        ArrayList respVoList = Lists.newArrayList();
        this.monthBridge(t, target, targetCodes, respVoList);
        this.ytdBridge(t, target, targetCodes, respVoList);
        return respVoList;
    }

    private void monthBridge(ReportReqVo t, SysSubjectTarget target, String[] targetCodes, List<FaTargetRespVo> respVoList) {
        List<FaReportRespVo> list;
        List<BridgeFigureVo> bridgeFigureVoList;
        FaTargetRespVo faTargetRespVo = new FaTargetRespVo();
        faTargetRespVo.setTargetName(target.getName() + "\u5f53\u6708\u6865\u56fe\u5206\u6790(\u4e07\u6b27)");
        if (!StringUtils.isEmpty((Object)target.getTargetNameEn())) {
            faTargetRespVo.setTargetNameEn(target.getTargetNameEn() + "bridge(10K\u20ac)");
        }
        if (CollectionUtils.isEmpty(bridgeFigureVoList = this.getBridgeFigureVos(list = ((QfFinancialStatisticalDao)this.baseMapper).bridgeFigureAnalysis(t, Arrays.asList(targetCodes)), target))) {
            return;
        }
        faTargetRespVo.setBridgeFigureList(bridgeFigureVoList);
        respVoList.add(faTargetRespVo);
    }

    private void ytdBridge(ReportReqVo t, SysSubjectTarget target, String[] targetCodes, List<FaTargetRespVo> respVoList) {
        List<FaReportRespVo> list = ((QfFinancialStatisticalDao)this.baseMapper).ytdBridgeFigureAnalysis(t, Arrays.asList(targetCodes));
        List<BridgeFigureVo> bridgeFigureVoList = this.getBridgeFigureVos(list, target);
        if (CollectionUtils.isEmpty(bridgeFigureVoList)) {
            return;
        }
        FaTargetRespVo faTargetRespVo = new FaTargetRespVo();
        faTargetRespVo.setTargetName(target.getName() + "\u5f53\u6708\u7d2f\u8ba1\u6865\u56fe\u5206\u6790(\u4e07\u6b27)");
        if (!StringUtils.isEmpty((Object)target.getTargetNameEn())) {
            faTargetRespVo.setTargetNameEn(target.getTargetNameEn() + "bridge(10K\u20ac)");
        }
        faTargetRespVo.setBridgeFigureList(bridgeFigureVoList);
        respVoList.add(faTargetRespVo);
    }

    private List<BridgeFigureVo> getBridgeFigureVos(List<FaReportRespVo> list, SysSubjectTarget target) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        ArrayList bridgeFigureVoList = Lists.newArrayList();
        list.forEach(resp -> {
            if (!resp.getTargetName().equals(target.getName())) {
                return;
            }
            BridgeFigureVo bridgeFigureVo = new BridgeFigureVo();
            bridgeFigureVo.setTargetName(resp.getTargetName() + "\u9884\u7b97");
            bridgeFigureVo.setTargetNameEn(resp.getTargetNameEn());
            bridgeFigureVo.setValue(resp.getBudget());
            bridgeFigureVoList.add(bridgeFigureVo);
        });
        BigDecimal actual = BigDecimal.ZERO;
        BigDecimal budget = BigDecimal.ZERO;
        for (FaReportRespVo reportRespVo : list) {
            if (!"\u4ea7\u54c1\u9500\u552e\u6536\u5165".equals(reportRespVo.getTargetName())) continue;
            actual = reportRespVo.getActual();
            budget = reportRespVo.getBudget();
        }
        BigDecimal finalActual = actual;
        BigDecimal finalBudget = budget;
        list.forEach(faReportRespVo -> {
            BridgeFigureVo resp = new BridgeFigureVo();
            if (faReportRespVo.getTargetName().equals(target.getName())) {
                return;
            }
            if (faReportRespVo.getTargetName().contains("\u7387")) {
                resp.setTargetName(faReportRespVo.getTargetName().substring(0, faReportRespVo.getTargetName().length() - 1));
                resp.setTargetNameEn(faReportRespVo.getTargetNameEn());
                resp.setValue(faReportRespVo.getActual().divide(new BigDecimal(100), 2, 4).multiply(finalActual).subtract(faReportRespVo.getBudget().divide(new BigDecimal(100), 2, 4).multiply(finalBudget)));
            } else {
                resp.setTargetName(faReportRespVo.getTargetName());
                resp.setTargetNameEn(faReportRespVo.getTargetNameEn());
                resp.setValue(faReportRespVo.getActual().subtract(faReportRespVo.getBudget()));
            }
            if ("\u4ea7\u54c1\u9500\u552e\u6536\u5165".equals(faReportRespVo.getTargetName()) || "\u5de5\u88c5\u6a21\u5177\u9500\u552e\u6536\u5165".equals(faReportRespVo.getTargetName())) {
                resp.setValue(resp.getValue());
            } else {
                resp.setValue(resp.getValue().multiply(new BigDecimal("-1")));
            }
            bridgeFigureVoList.add(resp);
        });
        BridgeFigureVo bridgeFigureVo = new BridgeFigureVo();
        list.forEach(resp -> {
            if (!resp.getTargetName().equals(target.getName())) {
                return;
            }
            bridgeFigureVo.setTargetName(resp.getTargetName() + "\u5b9e\u9645");
            bridgeFigureVo.setTargetNameEn(resp.getTargetNameEn());
            bridgeFigureVo.setValue(resp.getActual());
        });
        BridgeFigureVo other = new BridgeFigureVo();
        other.setTargetName("\u5176\u4ed6");
        other.setTargetNameEn("other");
        BigDecimal allValue = bridgeFigureVoList.stream().map(BridgeFigureVo::getValue).reduce(BigDecimal.ZERO, BigDecimal::add);
        other.setValue(bridgeFigureVo.getValue().subtract(allValue));
        bridgeFigureVoList.add(other);
        bridgeFigureVoList.add(bridgeFigureVo);
        bridgeFigureVoList.forEach(resp -> resp.setValue(resp.getValue().divide(new BigDecimal(10000), 2, 4)));
        return bridgeFigureVoList;
    }

    private void partitionSave(List<QfFinancialStatistical> detailList) throws InterruptedException {
        List partition = BeanUtils.partition(detailList, (int)(detailList.size() / 10));
        ExecutorService executorService = Executors.newFixedThreadPool(partition.size());
        CountDownLatch countDownLatch = new CountDownLatch(partition.size());
        int i = 0;
        while (i < partition.size()) {
            int finalI = i++;
            executorService.execute(() -> {
                List importParamDTOList = (List)partition.get(finalI);
                this.saveOrUpdateBatch(importParamDTOList);
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        executorService.shutdown();
    }

    private void saveFinancialStatistical(SysSubjectTarget target, List<QfFinancialStatistical> dataList, List<ReportVo> list, Integer dataType, DataInfoVo dataInfoVo, Map<String, QfEnterpriseInfo> enterpriseInfoMap) {
        Map<String, List<ReportVo>> enterpriseMap = list.stream().collect(Collectors.groupingBy(ReportVo::getEnterpriseCode));
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        enterpriseMap.forEach((enterpriseCode, financialVoList) -> {
            if (!enterpriseInfoMap.containsKey(enterpriseCode)) {
                return;
            }
            QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(enterpriseCode)));
            QfFinancialStatistical qfFinancialStatistical = new QfFinancialStatistical();
            qfFinancialStatistical.setTempCalculation(targetCalculation);
            qfFinancialStatistical.setEnterpriseCode((String)enterpriseCode);
            this.createInfo(target, dataInfoVo, qfFinancialStatistical);
            this.calculateData(dataType, targetCalculation, expressionKey, (List<ReportVo>)financialVoList, qfFinancialStatistical);
            if (!StringUtil.isNotEmpty((String)target.getAnalyseType()) || !AnalyseTypeEnum.getAreaType().contains(target.getAnalyseType())) {
                if (!StringUtil.isEmpty((String)qfEnterpriseInfo.getContinent())) {
                    qfFinancialStatistical.setEnterpriseArea(Integer.parseInt(qfEnterpriseInfo.getContinent()));
                }
                qfFinancialStatistical.setEnterpriseType(qfEnterpriseInfo.getBusinessType());
                dataList.add(qfFinancialStatistical);
            }
        });
    }

    private void updateFinancialStatistical(SysSubjectTarget target, List<QfFinancialStatistical> dataList, List<QfFinancialStatistical> statisticalList, List<ReportVo> list, Integer dataType, DataInfoVo dataInfoVo, Map<String, QfEnterpriseInfo> enterpriseInfoMap) {
        if (CollectionUtils.isEmpty(statisticalList)) {
            return;
        }
        Map<String, List<ReportVo>> enterpriseReportMap = list.stream().collect(Collectors.groupingBy(ReportVo::getEnterpriseCode));
        Map<String, List<QfFinancialStatistical>> statisticalMap = statisticalList.stream().collect(Collectors.groupingBy(QfFinancialStatistical::getEnterpriseCode));
        String targetCalculation = target.getTargetCalculation();
        List expressionKey = CommonUtil.getExpressionKey((String)targetCalculation);
        enterpriseReportMap.forEach((enterpriseCode, financialVoList) -> {
            if (!enterpriseInfoMap.containsKey(enterpriseCode)) {
                return;
            }
            QfEnterpriseInfo qfEnterpriseInfo = (QfEnterpriseInfo)((Object)((Object)enterpriseInfoMap.get(enterpriseCode)));
            List reportVos = (List)enterpriseReportMap.get(enterpriseCode);
            if (statisticalMap.containsKey(enterpriseCode)) {
                List statisticals = (List)statisticalMap.get(enterpriseCode);
                Map<String, QfFinancialStatistical> faMap = statisticals.stream().collect(Collectors.toMap(item -> item.getTargetId(), item -> item));
                QfFinancialStatistical qfFinancialStatistical = null;
                if (faMap.containsKey(target.getId())) {
                    qfFinancialStatistical = faMap.get(target.getId());
                    this.processFormulaChange(targetCalculation, qfFinancialStatistical);
                    qfFinancialStatistical.setTempCalculation(targetCalculation);
                } else {
                    qfFinancialStatistical = new QfFinancialStatistical();
                    qfFinancialStatistical.setTempCalculation(targetCalculation);
                    qfFinancialStatistical.setEnterpriseCode((String)enterpriseCode);
                    qfFinancialStatistical.setLastTime(LocalDateTime.now());
                    this.createInfo(target, dataInfoVo, qfFinancialStatistical);
                }
                this.calculateData(dataType, targetCalculation, expressionKey, reportVos, qfFinancialStatistical);
                if (!StringUtil.isNotEmpty((String)target.getAnalyseType()) || !AnalyseTypeEnum.getAreaType().contains(target.getAnalyseType())) {
                    if (!StringUtil.isEmpty((String)qfEnterpriseInfo.getContinent())) {
                        qfFinancialStatistical.setEnterpriseArea(Integer.parseInt(qfEnterpriseInfo.getContinent()));
                    }
                    qfFinancialStatistical.setEnterpriseType(qfEnterpriseInfo.getBusinessType());
                    qfFinancialStatistical.setLastTime(LocalDateTime.now());
                    dataList.add(qfFinancialStatistical);
                }
            }
        });
    }

    private void processFormulaChange(String targetCalculation, QfFinancialStatistical qfFinancialStatistical) {
        if (null == qfFinancialStatistical) {
            return;
        }
        if (StringUtil.isEmpty((String)targetCalculation)) {
            return;
        }
        if (StringUtils.isEmpty((Object)qfFinancialStatistical.getTempCalculation())) {
            return;
        }
        if (qfFinancialStatistical.getTempCalculation().equals(targetCalculation)) {
            return;
        }
        qfFinancialStatistical.setYtdTargetCalculation(null);
        qfFinancialStatistical.setTargetCalculation(null);
        qfFinancialStatistical.setActualYtd(null);
        qfFinancialStatistical.setBudgetYtd(null);
        qfFinancialStatistical.setActual(null);
        qfFinancialStatistical.setBudget(null);
    }

    private void calculateData(Integer dataType, String targetCalculation, List<String> expressionKey, List<ReportVo> financialVoList, QfFinancialStatistical qfFinancialStatistical) {
        this.theMonthValue(dataType, targetCalculation, expressionKey, financialVoList, qfFinancialStatistical);
        this.ytdValue(dataType, targetCalculation, expressionKey, financialVoList, qfFinancialStatistical);
    }

    private void theMonthValue(Integer dataType, String targetCalculation, List<String> expressionKey, List<ReportVo> financialVoList, QfFinancialStatistical statistical) {
        String targetCalculationJson = statistical.getTargetCalculation();
        Map map = (Map)JSONObject.parseObject((String)targetCalculationJson, Map.class);
        Map<String, BigDecimal> targetCalculationMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Map)map)) {
            map = Maps.newHashMap();
        } else if (map.containsKey(dataType) && null != map.get(dataType)) {
            targetCalculationMap = (Map)map.get(dataType);
        }
        Map<String, List<ReportVo>> containsSubjectMap = this.buildContainsSubjectMap(expressionKey, financialVoList);
        for (String key : expressionKey) {
            if (StringUtils.isEmpty((Object)key) || !containsSubjectMap.containsKey(key)) continue;
            List<ReportVo> list = containsSubjectMap.get(key);
            key = "U" + key;
            for (ReportVo financialVo : list) {
                if (StringUtils.isEmpty((Object)financialVo.getSubjectCode()) || !financialVo.getSubjectCode().equals(key.substring(1))) continue;
                if (ACTUAL_TYPE.equals(dataType) && null == financialVo.getActual()) {
                    financialVo.setActual(BigDecimal.ZERO);
                }
                if (BUDGET_TYPE.equals(dataType) && null == financialVo.getBudget()) {
                    financialVo.setBudget(BigDecimal.ZERO);
                }
                if (financialVo.getEnterpriseCode().equals("CIGR") && financialVo.getSubjectCode().equals("PL3300S")) {
                    System.out.println(1);
                }
                if (CollectionUtils.isEmpty((Map)map)) {
                    targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActual() : financialVo.getBudget());
                    map.put(dataType, targetCalculationMap);
                    continue;
                }
                Map stringBigDecimalMap = (Map)map.get(dataType);
                if (!CollectionUtils.isEmpty((Map)stringBigDecimalMap)) {
                    for (Map.Entry entry : stringBigDecimalMap.entrySet()) {
                        if (!key.equals(entry.getKey())) continue;
                        targetCalculationMap.put((String)entry.getKey(), ACTUAL_TYPE.equals(dataType) ? financialVo.getActual() : financialVo.getBudget());
                        break;
                    }
                    if (!targetCalculationMap.containsKey(key)) {
                        targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActual() : financialVo.getBudget());
                    } else {
                        targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActual() : financialVo.getBudget());
                    }
                    map.put(dataType, targetCalculationMap);
                    continue;
                }
                targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActual() : financialVo.getBudget());
            }
        }
        if (CollectionUtils.isEmpty(containsSubjectMap)) {
            for (String key : expressionKey) {
                key = "U" + key;
                if (targetCalculationMap.containsKey(key)) continue;
                targetCalculationMap.put(key, BigDecimal.ZERO);
            }
        }
        targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)targetCalculation);
        map.put(dataType, targetCalculationMap);
        statistical.setTargetCalculation(JSON.toJSONString((Object)map));
        if (!StringUtil.isNotEmpty((String)targetCalculation)) {
            return;
        }
        if (!StringUtil.isNotEmpty((String)statistical.getAnalyseType()) || AnalyseTypeEnum.getAreaType().contains(statistical.getAnalyseType())) {
            BigDecimal bigDecimal = CommonUtil.convertToCode((String)targetCalculation, targetCalculationMap, (int)4);
            bigDecimal = this.findByUnitCalculate(statistical, bigDecimal);
            if (ACTUAL_TYPE.equals(dataType)) {
                statistical.setActual(bigDecimal);
            } else if (BUDGET_TYPE.equals(dataType)) {
                statistical.setBudget(bigDecimal);
            }
        }
    }

    private void ytdValue(Integer dataType, String targetCalculation, List<String> expressionKey, List<ReportVo> financialVoList, QfFinancialStatistical statistical) {
        String targetCalculationJson = statistical.getYtdTargetCalculation();
        Map map = (Map)JSONObject.parseObject((String)targetCalculationJson, Map.class);
        Map<String, BigDecimal> targetCalculationMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty((Map)map)) {
            map = Maps.newHashMap();
        } else if (map.containsKey(dataType) && null != map.get(dataType)) {
            targetCalculationMap = (Map)map.get(dataType);
        }
        Map<String, List<ReportVo>> containsSubjectMap = this.buildContainsSubjectMap(expressionKey, financialVoList);
        for (String key : expressionKey) {
            if (StringUtils.isEmpty((Object)key) || !containsSubjectMap.containsKey(key)) continue;
            List<ReportVo> list = containsSubjectMap.get(key);
            key = "U" + key;
            for (ReportVo financialVo : list) {
                if (StringUtils.isEmpty((Object)financialVo.getSubjectCode()) || !financialVo.getSubjectCode().equals(key.substring(1))) continue;
                if (ACTUAL_TYPE.equals(dataType) && null == financialVo.getActualYtd()) {
                    financialVo.setActualYtd(BigDecimal.ZERO);
                }
                if (BUDGET_TYPE.equals(dataType) && null == financialVo.getBudgetYtd()) {
                    financialVo.setBudgetYtd(BigDecimal.ZERO);
                }
                if (CollectionUtils.isEmpty((Map)map)) {
                    targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActualYtd() : financialVo.getBudgetYtd());
                    map.put(dataType, targetCalculationMap);
                    continue;
                }
                Map stringBigDecimalMap = (Map)map.get(dataType);
                if (!CollectionUtils.isEmpty((Map)stringBigDecimalMap)) {
                    for (Map.Entry entry : stringBigDecimalMap.entrySet()) {
                        if (!key.equals(entry.getKey())) continue;
                        targetCalculationMap.put((String)entry.getKey(), ACTUAL_TYPE.equals(dataType) ? financialVo.getActualYtd() : financialVo.getBudgetYtd());
                        break;
                    }
                    if (!targetCalculationMap.containsKey(key)) {
                        targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActualYtd() : financialVo.getBudgetYtd());
                    } else {
                        targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActualYtd() : financialVo.getBudgetYtd());
                    }
                    map.put(dataType, targetCalculationMap);
                    continue;
                }
                targetCalculationMap.put(key, ACTUAL_TYPE.equals(dataType) ? financialVo.getActualYtd() : financialVo.getBudgetYtd());
            }
        }
        if (CollectionUtils.isEmpty(containsSubjectMap)) {
            for (String key : expressionKey) {
                key = "U" + key;
                if (targetCalculationMap.containsKey(key)) continue;
                targetCalculationMap.put(key, BigDecimal.ZERO);
            }
        }
        targetCalculation = CommonUtil.replaceExpression(expressionKey, (String)targetCalculation);
        map.put(dataType, targetCalculationMap);
        statistical.setYtdTargetCalculation(JSON.toJSONString((Object)map));
        if (!StringUtil.isNotEmpty((String)targetCalculation)) {
            return;
        }
        if (!StringUtil.isNotEmpty((String)statistical.getAnalyseType()) || AnalyseTypeEnum.getAreaType().contains(statistical.getAnalyseType())) {
            BigDecimal bigDecimal = CommonUtil.convertToCode((String)targetCalculation, targetCalculationMap, (int)4);
            bigDecimal = this.findByUnitCalculate(statistical, bigDecimal);
            if (ACTUAL_TYPE.equals(dataType)) {
                statistical.setActualYtd(bigDecimal);
            } else if (BUDGET_TYPE.equals(dataType)) {
                statistical.setBudgetYtd(bigDecimal);
            }
        }
    }

    private BigDecimal findByUnitCalculate(QfFinancialStatistical statistical, BigDecimal bigDecimal) {
        if (StringUtil.isNotEmpty((String)statistical.getTargetCalculation()) && "%".equals(statistical.getTargetUnit())) {
            bigDecimal = bigDecimal.multiply(new BigDecimal(100));
        }
        if ("\u5929".equals(statistical.getTargetUnit()) && null != bigDecimal && bigDecimal.doubleValue() != 0.0) {
            bigDecimal = new BigDecimal(60).multiply(new BigDecimal(statistical.getMonth())).divide(bigDecimal, 2, 4);
        }
        if ("\u6b21".equals(statistical.getTargetUnit())) {
            bigDecimal = bigDecimal.multiply(new BigDecimal(100));
        }
        return bigDecimal;
    }

    private Map<String, List<ReportVo>> buildContainsSubjectMap(List<String> expressionKey, List<ReportVo> financialVoList) {
        Map<String, List<ReportVo>> subjectMap = financialVoList.stream().collect(Collectors.groupingBy(ReportVo::getSubjectCode));
        HashMap containsSubjectMap = Maps.newHashMap();
        for (String key : expressionKey) {
            if (!subjectMap.containsKey(key)) continue;
            containsSubjectMap.put(key, subjectMap.get(key));
        }
        return containsSubjectMap;
    }

    private void createInfo(SysSubjectTarget target, DataInfoVo dataInfoVo, QfFinancialStatistical qfFinancialStatistical) {
        qfFinancialStatistical.setTargetId(target.getId());
        qfFinancialStatistical.setTargetLevel(target.getTargetLevel());
        qfFinancialStatistical.setTargetName(target.getName());
        qfFinancialStatistical.setTargetNameEn(target.getTargetNameEn());
        qfFinancialStatistical.setTargetUnit(target.getUnit());
        qfFinancialStatistical.setType(target.getType());
        qfFinancialStatistical.setStaLat(target.getStaLat());
        qfFinancialStatistical.setAnalyseType(target.getAnalyseType());
        qfFinancialStatistical.setLargerType(target.getLargerType());
        qfFinancialStatistical.setParentTargetId(target.getParentId());
        qfFinancialStatistical.setYear(dataInfoVo.getYear());
        qfFinancialStatistical.setQuarter(dataInfoVo.getQuarter());
        qfFinancialStatistical.setMonth(dataInfoVo.getMonth());
    }

    @Override
    public List<FaTargetRespVo> fromUnderData(ReportReqVo t) {
        Assert.hasText((String)t.getTargetId(), (String)"\u8bf7\u9009\u62e9\u8981\u7edf\u8ba1\u7684\u6307\u6807id");
        SysSubjectTarget target = (SysSubjectTarget)this.sysSubjectTargetManager.get((Serializable)((Object)t.getTargetId()));
        Assert.notNull((Object)((Object)target), (String)"\u5f53\u524d\u6307\u6807\u4e0d\u5b58\u5728");
        if (StringUtils.isEmpty((Object)target.getType())) {
            return Lists.newArrayList();
        }
        this.enterpriseInfoMap = this.enterpriseInfoManager.getEnterpriseInfoMap(null);
        QfEnterpriseInfo group = this.enterpriseInfoManager.getGroup();
        if (StringUtil.isEmpty((String)t.getEnterpriseCode()) || group.getCode().equals(t.getEnterpriseCode())) {
            t.setEnterpriseCode(group.getCode());
            t.setType(2);
        } else {
            t.setType(1);
        }
        ArrayList typeList = Arrays.asList(target.getType().split(","));
        ArrayList lowerLevelTargetList = this.sysSubjectTargetManager.lowerLevelTargetList(target.getSubjectId());
        if (!StringUtil.isEmpty((String)target.getRelatedCode())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"code_", (Object)target.getRelatedCode());
            SysSubjectTarget relatedTarget = (SysSubjectTarget)((Object)this.sysSubjectTargetManager.getOne((Wrapper)queryWrapper));
            if (null != relatedTarget) {
                relatedTarget.setSn(99);
                lowerLevelTargetList.add(relatedTarget);
            }
        }
        if (target.getCode().equals(PRODUCT_SALES_REVENUE) && 1 == t.getType()) {
            lowerLevelTargetList = Lists.newArrayList();
        }
        if (!CollectionUtils.isEmpty(lowerLevelTargetList)) {
            ArrayList newTypeList = Lists.newArrayList();
            for (int i = 0; i < typeList.size(); ++i) {
                if (i > 2) continue;
                newTypeList.add(typeList.get(i));
            }
            typeList = Lists.newArrayList((Iterable)newTypeList);
        }
        List<FaTargetRespVo> list = this.currentTargetAnalysis(target, typeList, t, lowerLevelTargetList, false);
        lowerLevelTargetList.forEach(lowerLevelTarget -> {
            List<Object> newTypeList = Lists.newArrayList();
            if ("Finance".equals(lowerLevelTarget.getBusiness())) {
                String[] type = new String[]{"5"};
                newTypeList = Arrays.asList(type);
            } else if ("money".equals(lowerLevelTarget.getBusiness())) {
                String[] type = new String[]{lowerLevelTarget.getType().split(",")[0]};
                newTypeList = Arrays.asList(type);
            }
            t.setTargetId(lowerLevelTarget.getId());
            list.addAll(this.currentTargetAnalysis((SysSubjectTarget)((Object)lowerLevelTarget), (List<String>)newTypeList, t, null, true));
        });
        if (!CollectionUtils.isEmpty(list)) {
            FaTargetRespVo faTargetRespVo = list.get(0);
            if (CollectionUtils.isEmpty((Collection)lowerLevelTargetList)) {
                faTargetRespVo.setLowerStatus("0");
                faTargetRespVo.setIsData("0");
            } else {
                faTargetRespVo.setLowerStatus("1");
                if (Arrays.asList(target.getType().split(",")).size() <= 3) {
                    faTargetRespVo.setIsData("0");
                } else {
                    faTargetRespVo.setIsData("1");
                }
            }
        }
        list.forEach(resp -> {
            if (resp.getContainType().contains(FaTargetTypeEnum.qt.getType().toString())) {
                resp.setBridgeFigure("1");
            } else {
                resp.setBridgeFigure("0");
            }
        });
        return list;
    }

    private List<FaTargetRespVo> currentTargetAnalysis(SysSubjectTarget target, List<String> typeList, ReportReqVo t, List<SysSubjectTarget> lowerLevelTargetList, boolean current) {
        ArrayList resultList = Lists.newArrayList();
        typeList.forEach(type -> {
            FaTargetTypeEnum targetTypeEnum = FaTargetTypeEnum.getTarget((String)type);
            if (null == targetTypeEnum) {
                return;
            }
            switch (targetTypeEnum) {
                case dysj: {
                    this.monthAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ljsj: {
                    this.monthYtdAnalysis(target, t, resultList, targetTypeEnum, current);
                    break;
                }
                case tbfx: {
                    this.comparedAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case hbfx: {
                    this.sequentialAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndsj: {
                    this.yearAnalysis(target, t, resultList, targetTypeEnum, current);
                    break;
                }
                case scqysj: {
                    this.productionEnterpriseAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case fscqysj: {
                    this.nonProductionEnterpriseAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zzlfx: {
                    this.growthRateAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case jtwclfx: {
                    this.groupCompletion(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zqywclfx: {
                    this.enterpriseCompletion(target, t, resultList, targetTypeEnum);
                    break;
                }
                case zbfx: {
                    this.ratioAnalysis(target, t, resultList, targetTypeEnum, lowerLevelTargetList);
                    break;
                }
                case zqydysj: {
                    this.meanRankAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case ndsy: {
                    this.yearAnalysis(target, t, resultList, targetTypeEnum, current);
                    break;
                }
                case jdlj: {
                    this.realTimeBalance(target, t, resultList, targetTypeEnum, current);
                    break;
                }
                case zqylj: {
                    this.companyAnalysis(target, t, resultList, targetTypeEnum, current);
                    break;
                }
                case yhdk: {
                    this.bankAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
                case yhyk: {
                    this.bankAnnualFigure(target, t, resultList, targetTypeEnum);
                    break;
                }
                case oyll: {
                    this.euroRatesAnalysis(target, t, resultList, targetTypeEnum);
                    break;
                }
            }
        });
        return resultList;
    }

    private void euroRatesAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        if (null == t.getYear()) {
            int year = LocalDate.now().getYear();
            t.setYear(year);
        }
        List<EuroRatesRespVo> euroRespList = this.euroRatesdManager.euroRatesAnalysis(t);
        Map<Integer, List<EuroRatesRespVo>> map = euroRespList.stream().collect(Collectors.groupingBy(EuroRatesRespVo::getMonth));
        ArrayList data = Lists.newArrayList();
        map.forEach((month, v) -> {
            EuroRatesRespVo ratesRespVo = new EuroRatesRespVo();
            ratesRespVo.setMonth((Integer)month);
            v.forEach(euroRatesRespVo -> {
                if (StringUtils.isEmpty((Object)euroRatesRespVo.getType())) {
                    return;
                }
                if ("1M".equals(euroRatesRespVo.getType())) {
                    ratesRespVo.setOneActual(euroRatesRespVo.getFillData());
                }
                if ("3M".equals(euroRatesRespVo.getType())) {
                    ratesRespVo.setThreeActual(euroRatesRespVo.getFillData());
                }
                if ("6M".equals(euroRatesRespVo.getType())) {
                    ratesRespVo.setSixActual(euroRatesRespVo.getFillData());
                }
            });
            data.add(ratesRespVo);
        });
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, null);
        resultFa.setEuroRatesList(data);
        resultList.add(resultFa);
    }

    private void bankAnnualFigure(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        t.setEnterpriseType(null);
        String dataType = null;
        if ("M003".equals(target.getCode())) {
            dataType = "1";
        }
        List<FaReportRespVo> bankLoanList = this.loandManager.bankAnnualFigure(t, dataType);
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, null);
        resultFa.setResultData(bankLoanList);
        resultList.add(resultFa);
    }

    private void bankAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        if (!t.getType().equals(CIGR_TYPE)) {
            return;
        }
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        t.setEnterpriseType(null);
        String dataType = null;
        if ("M003".equals(target.getCode())) {
            dataType = "1";
        } else if ("M006".equals(target.getCode())) {
            dataType = "2";
        }
        List<BankLoanDetailRespVo> bankLoanList = this.loandManager.bankDetail(t, dataType);
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, null);
        resultFa.setBankLoanList(bankLoanList);
        resultList.add(resultFa);
    }

    private void companyAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum, boolean current) {
        if (t.getType().equals(1)) {
            return;
        }
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        t.setEnterpriseType(null);
        List<Object> reportRespVos = Lists.newArrayList();
        String dataType = null;
        if ("M003".equals(target.getCode())) {
            reportRespVos = this.loandManager.dbzeQuarterCompanyAnalysis(t);
        } else if ("M006".equals(target.getCode())) {
            dataType = "2";
            reportRespVos = this.loandManager.dkyeQuarterCompanyAnalysis(t, dataType);
        }
        BigDecimal totalMoney = BigDecimal.ZERO;
        for (FaReportRespVo faReportRespVo : reportRespVos) {
            faReportRespVo.setTargetId(target.getId());
            faReportRespVo.setYear(t.getYear());
            faReportRespVo.setBudget(null);
            QfEnterpriseInfo qfEnterpriseInfo = this.enterpriseInfoMap.get(faReportRespVo.getEnterpriseCode());
            if (null != qfEnterpriseInfo) {
                faReportRespVo.setEnterpriseName(qfEnterpriseInfo.getShortName());
            }
            totalMoney = totalMoney.add(faReportRespVo.getActual());
        }
        FaTargetRespVo resultFa = null;
        if (current) {
            resultFa = this.financialTimeUtils.getFaTargetRespVo(target, type, reportRespVos);
            resultFa.setStaLat(target.getStaLat().trim());
        } else {
            resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        }
        resultFa.setTotalMoney(totalMoney);
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void realTimeBalance(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum, boolean current) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        t.setEnterpriseType(null);
        if (t.getType().equals(CIGR_TYPE)) {
            t.setEnterpriseCode(null);
        }
        boolean flag = false;
        List<Object> reportRespVos = Lists.newArrayList();
        if ("M003".equals(target.getCode())) {
            reportRespVos = this.loandManager.nbwdYearAnalysis(t);
            flag = true;
        } else if ("M006".equals(target.getCode())) {
            reportRespVos = this.loandManager.zzrzYearAnalysis(t);
        }
        FaTargetRespVo resultFa = null;
        if (current) {
            resultFa = this.financialTimeUtils.getFaTargetRespVo(target, type, (List<FaReportRespVo>)reportRespVos);
            resultFa.setStaLat(target.getStaLat().trim());
        } else {
            resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, (List<FaReportRespVo>)reportRespVos);
        }
        reportRespVos.forEach(report -> {
            report.setTargetId(target.getId());
            report.setDifferenceRate(null);
            report.setDifferenceValue(null);
        });
        resultFa.setResultData(reportRespVos);
        if (flag) {
            resultFa.setControlMoney(new BigDecimal("13000"));
            BigDecimal earlyGuaranteeMoney = this.loandManager.getEarlyGuaranteeMoney(t.getYear());
            resultFa.setEarlyGuaranteeMoney(earlyGuaranteeMoney);
        }
        resultList.add(resultFa);
    }

    private void meanRankAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        if (t.getType().equals(1)) {
            return;
        }
        t.setTargetId(target.getId());
        BigDecimal meanRank = this.plsManager.getMeanRank(t, target);
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).meanRankAnalysis(t);
        if (!CollectionUtils.isEmpty(reportRespVos)) {
            reportRespVos.forEach(report -> {
                QfEnterpriseInfo qfEnterpriseInfo;
                report.setBudget(meanRank);
                if (null == report.getActual()) {
                    report.setActual(BigDecimal.ZERO);
                }
                if (null != (qfEnterpriseInfo = this.enterpriseInfoMap.get(report.getEnterpriseCode()))) {
                    report.setEnterpriseName(qfEnterpriseInfo.getShortName());
                }
            });
            reportRespVos.sort(Comparator.comparing(FaReportRespVo::getActual));
        }
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        resultFa.setTargetUnit("%");
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void ratioAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum, List<SysSubjectTarget> lowerLevelTargetList) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        if (t.getType().equals(COMPANY_TYPE) && PRODUCT_SALES_REVENUE.equals(target.getCode())) {
            return;
        }
        if (t.getType().equals(CIGR_TYPE) && PRODUCT_SALES_REVENUE.equals(target.getCode())) {
            t.setEnterpriseCode(null);
        }
        if (CollectionUtils.isEmpty(lowerLevelTargetList)) {
            return;
        }
        List<String> targetIds = lowerLevelTargetList.stream().map(SysSubjectTarget::getId).collect(Collectors.toList());
        List<FaReportRespVo> targetData = ((QfFinancialStatisticalDao)this.baseMapper).targetData(t, targetIds);
        List<FaReportRespVo> targetAllData = ((QfFinancialStatisticalDao)this.baseMapper).targetAllData(t);
        Map<Integer, List<FaReportRespVo>> monthMap = targetData.stream().collect(Collectors.groupingBy(FaReportRespVo::getMonth));
        ArrayList reportRespVos = Lists.newArrayList();
        HashMap currentTargetActualMap = Maps.newHashMap();
        HashMap currentTargetBudgetMap = Maps.newHashMap();
        targetAllData.forEach(qfFinancialStatistical -> {
            BigDecimal actual = BigDecimal.ZERO;
            BigDecimal budget = BigDecimal.ZERO;
            if (null != qfFinancialStatistical.getActual()) {
                actual = qfFinancialStatistical.getActual();
            }
            if (null != qfFinancialStatistical.getBudget()) {
                budget = qfFinancialStatistical.getBudget();
            }
            currentTargetActualMap.put(qfFinancialStatistical.getMonth(), actual);
            currentTargetBudgetMap.put(qfFinancialStatistical.getMonth(), budget);
        });
        HashMap targetActualMap = Maps.newHashMap();
        HashMap targetBudgetMap = Maps.newHashMap();
        monthMap.forEach((month, v) -> {
            targetActualMap.put(month, v.stream().map(FaReportRespVo::getActual).reduce(BigDecimal.ZERO, BigDecimal::add));
            targetBudgetMap.put(month, v.stream().map(FaReportRespVo::getBudget).reduce(BigDecimal.ZERO, BigDecimal::add));
        });
        Map<String, List<FaReportRespVo>> targetMap = targetData.stream().collect(Collectors.groupingBy(FaReportRespVo::getTargetId));
        targetMap.forEach((targetId, v) -> {
            Map<Integer, FaReportRespVo> collect = v.stream().collect(Collectors.toMap(item -> item.getMonth(), item -> item));
            collect.forEach((k, qfFinancialStatistical) -> {
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                if (null == qfFinancialStatistical.getBudget()) {
                    qfFinancialStatistical.setBudget(BigDecimal.ZERO);
                }
                if (null == qfFinancialStatistical.getActual()) {
                    qfFinancialStatistical.setActual(BigDecimal.ZERO);
                }
                faReportRespVo.setTargetId(qfFinancialStatistical.getTargetId());
                faReportRespVo.setTargetName(qfFinancialStatistical.getTargetName());
                faReportRespVo.setTargetNameEn(qfFinancialStatistical.getTargetNameEn());
                BigDecimal actual = BigDecimal.ZERO;
                BigDecimal budget = BigDecimal.ZERO;
                if (null != currentTargetActualMap.get(k) && 0.0 != ((BigDecimal)currentTargetActualMap.get(k)).doubleValue()) {
                    actual = qfFinancialStatistical.getActual().divide((BigDecimal)currentTargetActualMap.get(k), 4, 4).multiply(new BigDecimal(100));
                }
                if (null != currentTargetBudgetMap.get(k) && 0.0 != ((BigDecimal)currentTargetBudgetMap.get(k)).doubleValue()) {
                    budget = qfFinancialStatistical.getBudget().divide((BigDecimal)currentTargetBudgetMap.get(k), 4, 4).multiply(new BigDecimal(100));
                }
                faReportRespVo.setActual(actual);
                faReportRespVo.setBudget(budget);
                faReportRespVo.setMonth((Integer)k);
                faReportRespVo.setYear(qfFinancialStatistical.getYear());
                reportRespVos.add(faReportRespVo);
            });
        });
        if (!target.getCode().equals(PRODUCT_SALES_REVENUE)) {
            monthMap.forEach((k, v) -> {
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                faReportRespVo.setTargetName("\u5176\u4ed6");
                faReportRespVo.setTargetNameEn("other");
                BigDecimal otherActual = BigDecimal.ZERO;
                BigDecimal otherbudget = BigDecimal.ZERO;
                if (null != currentTargetActualMap.get(k) && null != currentTargetBudgetMap.get(k) && 0.0 != ((BigDecimal)currentTargetActualMap.get(k)).doubleValue() && 0.0 != ((BigDecimal)currentTargetBudgetMap.get(k)).doubleValue()) {
                    otherActual = ((BigDecimal)currentTargetActualMap.get(k)).subtract((BigDecimal)targetActualMap.get(k));
                    otherbudget = ((BigDecimal)currentTargetBudgetMap.get(k)).subtract((BigDecimal)targetBudgetMap.get(k));
                    otherActual = otherActual.divide((BigDecimal)currentTargetActualMap.get(k), 4, 4).multiply(new BigDecimal(100));
                    otherbudget = otherbudget.divide((BigDecimal)currentTargetBudgetMap.get(k), 4, 4).multiply(new BigDecimal(100));
                }
                faReportRespVo.setActual(otherActual);
                faReportRespVo.setBudget(otherbudget);
                faReportRespVo.setMonth((Integer)k);
                faReportRespVo.setYear(t.getYear());
                reportRespVos.add(faReportRespVo);
            });
        }
        target.setUnit("%");
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void enterpriseCompletion(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        if (t.getType().equals(1)) {
            return;
        }
        t.setTargetId(target.getId());
        target.setUnit("%");
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).enterpriseCompletion(t);
        if (!CollectionUtils.isEmpty(reportRespVos)) {
            reportRespVos.forEach(report -> {
                if (null == report.getBudget()) {
                    report.setBudget(BigDecimal.ZERO);
                }
                if (report.getBudget().doubleValue() == 0.0) {
                    report.setActual(BigDecimal.ZERO);
                } else {
                    report.setActual(report.getActual().divide(report.getBudget(), 4, 4).multiply(new BigDecimal(100)));
                }
                report.setBudget(null);
                QfEnterpriseInfo qfEnterpriseInfo = this.enterpriseInfoMap.get(report.getEnterpriseCode());
                if (null != qfEnterpriseInfo) {
                    report.setEnterpriseName(qfEnterpriseInfo.getShortName());
                }
            });
            reportRespVos.sort(Comparator.comparing(FaReportRespVo::getActual));
        }
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void groupCompletion(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        if (t.getType().equals(1)) {
            return;
        }
        t.setTargetId(target.getId());
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).groupCompletion(t);
        if (!CollectionUtils.isEmpty(reportRespVos)) {
            reportRespVos.forEach(report -> {
                if (null == report.getBudget()) {
                    report.setBudget(BigDecimal.ZERO);
                }
                if (report.getBudget().doubleValue() == 0.0) {
                    report.setActual(BigDecimal.ZERO);
                } else {
                    report.setActual(report.getActual().divide(report.getBudget(), 4, 4).multiply(new BigDecimal(100)));
                }
                report.setBudget(null);
            });
        }
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        resultFa.setTargetUnit("%");
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void growthRateAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        target.setUnit("%");
        List<FaReportRespVo> monthData = ((QfFinancialStatisticalDao)this.baseMapper).growthRateAnalysis(t);
        ArrayList reportRespVos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(monthData)) {
            Map<Integer, FaReportRespVo> respVoMap = monthData.stream().collect(Collectors.toMap(item -> item.getYear(), item -> item));
            for (int i = t.getStartYear().intValue(); i <= t.getEndYear(); ++i) {
                if (i == t.getStartYear()) continue;
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                BigDecimal currentMonthActual = BigDecimal.ZERO;
                BigDecimal lastMonthActual = BigDecimal.ZERO;
                if (respVoMap.containsKey(i) && null != respVoMap.get(i).getActual()) {
                    currentMonthActual = respVoMap.get(i).getActual();
                }
                if (respVoMap.containsKey(i - 1) && null != respVoMap.get(i - 1).getActual()) {
                    lastMonthActual = respVoMap.get(i - 1).getActual();
                }
                faReportRespVo.setMonth(t.getMonth());
                faReportRespVo.setYear(i);
                faReportRespVo.setTargetId(t.getTargetId());
                if (null == lastMonthActual || lastMonthActual.doubleValue() == 0.0) {
                    faReportRespVo.setActual(BigDecimal.ZERO);
                } else {
                    faReportRespVo.setActual(currentMonthActual.subtract(lastMonthActual).divide(lastMonthActual, 4, 4).multiply(new BigDecimal(100)));
                }
                faReportRespVo.setBudget(null);
                reportRespVos.add(faReportRespVo);
            }
        }
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        resultFa.setTargetUnit("%");
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void nonProductionEnterpriseAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        if (t.getType().equals(1)) {
            return;
        }
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        t.setEnterpriseType(null);
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).enterpriseAnalysis(t);
        reportRespVos.forEach(resp -> {
            QfEnterpriseInfo qfEnterpriseInfo = this.enterpriseInfoMap.get(resp.getEnterpriseCode());
            if (null != qfEnterpriseInfo) {
                resp.setEnterpriseName(qfEnterpriseInfo.getShortName());
            }
        });
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        reportRespVos.sort(Comparator.nullsLast(Comparator.comparing(FaReportRespVo::getDifferenceValue)));
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void productionEnterpriseAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        if (t.getType().equals(1)) {
            return;
        }
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        t.setEnterpriseType(1);
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).enterpriseAnalysis(t);
        reportRespVos.forEach(resp -> {
            QfEnterpriseInfo qfEnterpriseInfo = this.enterpriseInfoMap.get(resp.getEnterpriseCode());
            if (null != qfEnterpriseInfo) {
                resp.setEnterpriseName(qfEnterpriseInfo.getShortName());
            }
        });
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        reportRespVos.sort(Comparator.nullsLast(Comparator.comparing(FaReportRespVo::getDifferenceValue)));
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void yearAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum, boolean current) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).yearAnalysis(t);
        FaTargetRespVo resultFa = null;
        if (current) {
            resultFa = this.financialTimeUtils.getFaTargetRespVo(target, type, reportRespVos);
            resultFa.setStaLat("3,4");
            FaTargetRespVo finalResultFa = resultFa;
            reportRespVos.forEach(reportRespVo -> {
                if (null != reportRespVo.getBudget() && null != reportRespVo.getActual()) {
                    BigDecimal differenceValue = reportRespVo.getActual().subtract(reportRespVo.getBudget());
                    reportRespVo.setDifferenceValue(differenceValue);
                    String differenceRate = null;
                    if (0.0 != reportRespVo.getBudget().doubleValue()) {
                        differenceRate = differenceValue.divide(reportRespVo.getBudget(), 2, 4).multiply(new BigDecimal("100")) + "%";
                    }
                    if (!"%".equals(finalResultFa.getTargetUnit())) {
                        reportRespVo.setDifferenceRate(differenceRate);
                    }
                }
            });
        } else {
            resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        }
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void sequentialAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        List<FaReportRespVo> monthData = ((QfFinancialStatisticalDao)this.baseMapper).sequentialAnalysis(t);
        ArrayList reportRespVos = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(monthData)) {
            Map<Integer, FaReportRespVo> respVoMap = monthData.stream().collect(Collectors.toMap(item -> item.getMonth(), item -> item));
            for (int i = 1; i < t.getEndMonth(); ++i) {
                if (i == 1) continue;
                FaReportRespVo faReportRespVo = new FaReportRespVo();
                BigDecimal currentMonthActual = BigDecimal.ZERO;
                BigDecimal lastMonthActual = BigDecimal.ZERO;
                if (respVoMap.containsKey(i) && null != respVoMap.get(i).getActual()) {
                    currentMonthActual = respVoMap.get(i).getActual();
                }
                if (respVoMap.containsKey(i - 1) && null != respVoMap.get(i - 1).getActual()) {
                    lastMonthActual = respVoMap.get(i - 1).getActual();
                }
                faReportRespVo.setMonth(i);
                faReportRespVo.setYear(t.getYear());
                faReportRespVo.setTargetId(t.getTargetId());
                faReportRespVo.setActual(currentMonthActual.subtract(lastMonthActual));
                if (lastMonthActual.doubleValue() != 0.0) {
                    BigDecimal growthRate = currentMonthActual.subtract(lastMonthActual).divide(lastMonthActual, 4, 4).multiply(new BigDecimal(100));
                    faReportRespVo.setGrowthRate(growthRate);
                } else {
                    faReportRespVo.setGrowthRate(BigDecimal.ZERO);
                }
                reportRespVos.add(faReportRespVo);
            }
        }
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        reportRespVos.forEach(resp -> resp.setDifferenceRate(null));
        resultFa.setResultData(reportRespVos);
        resultFa.setStaLat("14");
        resultList.add(resultFa);
    }

    private void comparedAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).comparedAnalysis(t);
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        ArrayList list = Lists.newArrayList();
        Map<Integer, List<FaReportRespVo>> monthMap = reportRespVos.stream().collect(Collectors.groupingBy(FaReportRespVo::getMonth));
        monthMap.forEach((month, v) -> {
            if (v.size() <= 1) {
                return;
            }
            BigDecimal thisYearActual = ((FaReportRespVo)v.get(v.size() - 1)).getActual();
            BigDecimal lastYearActual = ((FaReportRespVo)v.get(0)).getActual();
            BigDecimal growthRate = null;
            growthRate = null == lastYearActual || lastYearActual.doubleValue() == 0.0 ? BigDecimal.ZERO : thisYearActual.subtract(lastYearActual).divide(lastYearActual, 4, 4).multiply(new BigDecimal(100));
            for (FaReportRespVo resp : v) {
                resp.setGrowthRate(growthRate);
                resp.setDifferenceRate(null);
                list.add(resp);
            }
        });
        list.sort(Comparator.comparing(FaReportRespVo::getMonth));
        resultFa.setResultData(list);
        resultList.add(resultFa);
    }

    private void monthYtdAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum, boolean current) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, type);
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).monthYtdData(t);
        FaTargetRespVo resultFa = null;
        if (current) {
            resultFa = this.financialTimeUtils.getFaTargetRespVo(target, type, reportRespVos);
            resultFa.setStaLat("3,4");
        } else {
            resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        }
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }

    private void monthAnalysis(SysSubjectTarget target, ReportReqVo t, List<FaTargetRespVo> resultList, FaTargetTypeEnum targetTypeEnum) {
        String type = targetTypeEnum.getType().toString();
        DateReqVo dateReqVo = this.financialTimeUtils.processDateReqVo(t, targetTypeEnum.getType().toString());
        this.financialTimeUtils.processDateQuery(t, dateReqVo);
        t.setTargetId(target.getId());
        List<FaReportRespVo> reportRespVos = ((QfFinancialStatisticalDao)this.baseMapper).monthData(t);
        FaTargetRespVo resultFa = this.financialTimeUtils.getCurrentFaTargetRespVo(targetTypeEnum, target, type, reportRespVos);
        resultFa.setResultData(reportRespVos);
        resultList.add(resultFa);
    }
}

