package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmWatermarkTypeManager;
import com.artfess.bpm.persistence.model.BpmWatermarkType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 
 * <pre> 
 * 描述：水印分配分类 控制器类
 * 构建组：x7
 * 作者:qiuxd
 * 邮箱:qiuxd@jee-soft.cn
 * 日期:2020-09-08 11:51:49
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/bpmModel/bpmWatermarkType/v1")
@Api(tags="bpmWatermarkTypeController")
public class BpmWatermarkTypeController extends BaseController<BpmWatermarkTypeManager,BpmWatermarkType>{
	@Resource
	BpmWatermarkTypeManager bpmWatermarkTypeManager;
	
	/**
	 * 水印分配分类列表(分页条件查询)数据
	 * @param queryFilter
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="水印分配分类数据列表", httpMethod = "POST", notes = "获取水印分配分类列表")
	public PageList<BpmWatermarkType> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter queryFilter) throws Exception{
		return bpmWatermarkTypeManager.query(queryFilter);
	}
	
	/**
	 * 水印分配分类明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="水印分配分类数据详情",httpMethod = "GET",notes = "水印分配分类数据详情")
	public BpmWatermarkType get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return bpmWatermarkTypeManager.get(id);
	}
	
    /**
	 * 新增水印分配分类
	 * @param bpmWatermarkType
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新水印分配分类数据", httpMethod = "POST", notes = "新增,更新水印分配分类数据")
	public CommonResult<String> save(@ApiParam(name="bpmWatermarkType",value="水印分配分类业务对象", required = true)@RequestBody BpmWatermarkType bpmWatermarkType) throws Exception{
		String msg = "添加水印分配分类成功";
		if(StringUtil.isEmpty(bpmWatermarkType.getId())){
			bpmWatermarkTypeManager.create(bpmWatermarkType);
		}else{
			bpmWatermarkTypeManager.update(bpmWatermarkType);
			 msg = "更新水印分配分类成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除水印分配分类记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除水印分配分类记录", httpMethod = "DELETE", notes = "批量删除水印分配分类记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		bpmWatermarkTypeManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}

	/**
	 * 批量添加
	 * @param watermarkTypes
	 * @param isAllSave 是否全部保存，1为是，0为否
	 * @return
	 */
	@PostMapping(value="/batchAdd")
	@ApiOperation(value = "批量添加", httpMethod = "POST", notes = "批量添加")
	public CommonResult<String> batchAdd(
			@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestBody List<BpmWatermarkType> watermarkTypes,@RequestParam(value="isAllSave") int isAllSave){
		bpmWatermarkTypeManager.batchAdd(watermarkTypes, isAllSave);
		return new CommonResult<>(true,"添加成功");
	}

	@PostMapping(value="/isExist")
	@ApiOperation(value = "是否存在", httpMethod = "POST", notes = "是否存在")
	public CommonResult<String> isExist(
			@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestBody List<BpmWatermarkType> watermarkTypes){
		return bpmWatermarkTypeManager.isExist(watermarkTypes);
	}
}
