package com.artfess.uc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.manager.LoginLogManager;
import com.artfess.uc.model.LoginLog;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

/**
 * 
 * <pre> 
 * 描述：用户登录日志统计表 控制器类
 * 构建组：artfess
 * 作者:baseli
 * 日期:2021年6月9日15:46:28
 * </pre>
 */
@RestController
@RequestMapping(value="/userCenter/loginLog/v1")
@Api(tags = "登录日志统计")
@ApiGroup(group = {ApiGroupConsts.GROUP_APPLICATION})
public class LoginLogController extends BaseController<LoginLogManager,LoginLog>{
	@Resource
	LoginLogManager loginLogManager;
	
	/**
	 * 用户登录日志统计表列表(分页条件查询)数据
	 * @param queryFilter
	 * @return
	 * @throws Exception 
	 * PageJson
	 * @exception 
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="用户登录日志统计表数据列表", httpMethod = "POST", notes = "获取用户登录日志统计表列表")
	public PageList<LoginLog> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter queryFilter) throws Exception{
		return loginLogManager.query(queryFilter);
	}
	
	/**
	 * 用户登录日志统计表明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="用户登录日志统计表数据详情",httpMethod = "GET",notes = "用户登录日志统计表数据详情")
	public LoginLog get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return loginLogManager.get(id);
	}
	
    /**
	 * 新增用户登录日志统计表
	 * @param loginLog
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "添加/修改用户登录日志统计表数据", httpMethod = "POST", notes = "新增,更新用户登录日志统计表数据")
	public CommonResult<String> save(@ApiParam(name="loginLog",value="用户登录日志统计表业务对象", required = true)@RequestBody LoginLog loginLog) throws Exception{
		String msg = "添加用户登录日志统计表成功";
		if(StringUtil.isEmpty(loginLog.getId())){
			loginLogManager.create(loginLog);
		}else{
			loginLogManager.update(loginLog);
			 msg = "更新用户登录日志统计表成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 批量删除用户登录日志统计表记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除用户登录日志统计表记录", httpMethod = "DELETE", notes = "批量删除用户登录日志统计表记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		loginLogManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}
}
