/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.utils;

import cn.hutool.core.io.IoUtil;
import cn.hutool.poi.excel.ExcelWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);

    public static void downloadExcel(HttpServletResponse response, String fileName, ExcelWriter writer) {
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        ServletOutputStream out = null;
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8") + ".xls");
            out = response.getOutputStream();
            writer.flush((OutputStream)out, true);
            writer.close();
            IoUtil.close((Closeable)out);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    public static void setSizeColumn(Sheet sheet, int size) {
        for (int columnNum = 0; columnNum <= size; ++columnNum) {
            int columnWidth = sheet.getColumnWidth(columnNum) / 256;
            for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                Cell currentCell;
                int length;
                Row currentRow = sheet.getRow(rowNum) == null ? sheet.createRow(rowNum) : sheet.getRow(rowNum);
                if (currentRow.getCell(columnNum) == null || columnWidth >= (length = (currentCell = currentRow.getCell(columnNum)).getStringCellValue().getBytes().length)) continue;
                columnWidth = length;
            }
            sheet.setColumnWidth(columnNum, columnWidth * 256);
        }
    }
}

