package com.artfess.manage.safty.model;


import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 安全责任书(CmgtSaftyLiability)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-04 13:50:03
 */
@Data
@ApiModel("安全责任书(CmgtSaftyLiability)表实体类")
@TableName("CMGT_SAFTY_LIABILITY")
public class CmgtSaftyLiability extends AutoFillModel<CmgtSaftyLiability> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty("签订年度")
    @TableField("sign_year_")
    private String signYear;

    @ApiModelProperty("单位类型（1：九小场所 2：重点单位 3：其它单位）")
    @TableField("company_type_")
    private String companyType;

    @ApiModelProperty("签订单位_ID")
    @TableField("sign_company_id_")
    private String signCompanyId;

    @ApiModelProperty("签订单位名称")
    @TableField("sign_company_name_")
    private String signCompanyName;

    @ApiModelProperty("签定人")
    @TableField("signer_")
    private String signer;

    @ApiModelProperty("签定日期")
    @TableField("sign_date_")
    private LocalDate signDate;

    @ApiModelProperty("排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty("备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}

