package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.manage.safty.dao.CmgtSaftyTargetDao;
import com.artfess.manage.safty.manager.CmgtSaftyTargetCheckManager;
import com.artfess.manage.safty.manager.CmgtSaftyTargetManager;
import com.artfess.manage.safty.model.CmgtSaftyTarget;
import com.artfess.manage.safty.model.CmgtSaftyTargetCheck;
import com.artfess.uc.dao.UserDao;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 安全工作目标信息 服务实现类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyTargetManagerImpl extends BaseManagerImpl<CmgtSaftyTargetDao, CmgtSaftyTarget> implements CmgtSaftyTargetManager {

    @Resource
    private UserDao userDao;
    @Resource
    private CmgtSaftyTargetCheckManager checkManager;

    @Override
    public PageList<CmgtSaftyTarget> query(QueryFilter<CmgtSaftyTarget> queryFilter) {
        List<CmgtSaftyTargetCheck> details = checkManager.list();
        PageList<CmgtSaftyTarget> result = super.query(queryFilter);
        result.getRows().forEach(r -> r.getDetail().addAll(details.stream()
                .filter(d -> r.getId().equals(d.getTargetId()))
                .collect(Collectors.toList())));
        return result;
    }

    @Override
    public CmgtSaftyTarget getById(Serializable id) {
        CmgtSaftyTarget result = super.getById(id);
        List<CmgtSaftyTargetCheck> detils = checkManager.list(new QueryWrapper<CmgtSaftyTargetCheck>().eq("target_year_", id));
        result.setDetail(detils);
        return result;
    }

    @Override
    public void removeByIds(String... ids) {
        List<String> detailIds = checkManager
                .list(new QueryWrapper<CmgtSaftyTargetCheck>().in("target_year_", ids))
                .stream()
                .map(CmgtSaftyTargetCheck::getId)
                .collect(Collectors.toList());
        checkManager.removeByIds(detailIds);
        super.removeByIds(ids);
    }

    @Override
    public boolean save(CmgtSaftyTarget entity) {
        if (entity.getSn() == null) {
            entity.setSn(count() + 1);
        }
        boolean result = super.save(entity);
        if (BeanUtils.isNotEmpty(entity.getDetail())) {
            entity.getDetail().forEach(d -> d.setTargetId(entity.getId()));
            checkManager.saveBatch(entity.getDetail());
        }
        return result;
    }

    @Override
    public boolean updateById(CmgtSaftyTarget entity) {
        return super.updateById(entity);
    }

}
