package com.artfess.manage.material.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;



/**
 * cmgt_material_warehouse_inout
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-09-05
 */
@Data
@ApiModel(value="CmgtMaterialWarehouseInoutDto", description="物资出入库单DTO对象")
public class CmgtMaterialWarehouseInoutDto extends ManageBaseModel<CmgtMaterialWarehouseInoutDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 出入库标识 */
    @ApiModelProperty(value = "出入库标识")
    private String dataType;




    /** 仓库 */
    @ApiModelProperty(value = "仓库")
    private String warehouse;




    /** 出入库日期 */
    @ApiModelProperty(value = "出入库日期")
    private LocalDate inoutDate;




    /** 采购来源 */
    @ApiModelProperty(value = "采购来源")
    private String source;




    /** 描述 */
    @ApiModelProperty(value = "描述")
    private String descripton;




    /** 申请人 */
    @ApiModelProperty(value = "申请人")
    private String applicant;


    @ApiModelProperty(value = "申请人ID")
    private String applicantId;

    /** 申请人部门 */
    @ApiModelProperty(value = "申请人部门")
    private String org;




    @ApiModelProperty(value = "")
    private String orgId;




    /** 审核人 */
    @ApiModelProperty(value = "审核人")
    private String approver;




    /** 审核时间 */
    @ApiModelProperty(value = "审核时间")
    private LocalDate approvedDate;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;




    @ApiModelProperty(value = "")
    private String amount;




    @ApiModelProperty(value = "")
    private String status;





    private String createByName;

}
