package com.artfess.manage.material.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 物资出入库单 服务类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-25
 */
public interface CmgtMaterialWarehouseInoutManager extends BaseManager<CmgtMaterialWarehouseInout> {

    /**
     * 新增出入库单
     *
     * @param inout
     * @return
     */
    public Boolean createInout(CmgtMaterialWarehouseInout inout);

    /**
     * 修改出入库单
     *
     * @param inout
     * @return
     */
    public Boolean updateInout(CmgtMaterialWarehouseInout inout);

    /**
     * 修改库存值：入库
     *
     * @param dlist     入库单明细
     * @param warehouse 仓库
     * @return
     */
    public void addQuantity(List<CmgtMaterialWarehouseInoutDetail> dlist, String warehouse);

    /**
     * 修改库存值：出库
     *
     * @param wid 入库单ID
     * @return
     */
    public Boolean subtractQuantity(String wid, String warehouse);

    /**
     * 修改领用单时检查库存数目是否足够
     *
     * @param wid    入库单ID
     * @param mid    物资ID
     * @param nowNum 现在入库数量
     * @return
     */
    public BigDecimal getQuantity(String wid, String mid, BigDecimal nowNum);

    /**
     * 根据ID批量删除
     *
     * @param ids
     * @return
     */
    public Boolean removeInoutById(String... ids);

    /**
     * @param mdata
     */
    public void importRKData(List<Map<String, Object>> mdata);
}
