package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.manager.DwdSjFestivalHolidayManager;
import com.artfess.manage.dwd.manager.dto.DwdSjFestivalHolidayDto;
import com.artfess.manage.dwd.manager.mapper.DwdSjFestivalHolidayDtoMapper;
import com.artfess.manage.dwd.model.DwdSjFestivalHoliday;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 生活服务-节假日信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-10-07
 */
@Service
public class DwdSjFestivalHolidayManagerImpl extends BaseManagerImpl<DwdSjFestivalHolidayDao, DwdSjFestivalHoliday> implements DwdSjFestivalHolidayManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;

    @Resource
    private DwdSjFestivalHolidayDtoMapper dwdSjFestivalHolidayDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdSjFestivalHolidayDto> pageQuery(QueryFilter<DwdSjFestivalHoliday> queryFilter) {
        PageList<DwdSjFestivalHoliday> result = query(queryFilter);
        PageList<DwdSjFestivalHolidayDto> r = new PageList<DwdSjFestivalHolidayDto>(
                result.getRows().stream().map(e -> {
                            DwdSjFestivalHolidayDto t = dwdSjFestivalHolidayDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdSjFestivalHoliday t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdSjFestivalHoliday t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdSjFestivalHoliday t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdSjFestivalHolidayDto dto) {
        DwdSjFestivalHoliday t = dwdSjFestivalHolidayDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdSjFestivalHolidayDto dto) {
        DwdSjFestivalHoliday t = dwdSjFestivalHolidayDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
