package com.artfess.manage.duty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * @Description: 排班人员信息
 * @ClassName: CmgtDutyWorkarrangeMember
 * @Author: wjl
 * @Date: 2022/8/17 12:26
 * @Version: 1.0
 */
@Data
@ApiModel(value="CmgtDutyWorkclass对象", description="班种信息")
public class CmgtDutyWorkarrangeMember extends AutoFillModel<CmgtDutyWorkarrangeMember> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "排班ID",groups = {AddGroup.class})
    @ApiModelProperty(value = "排班ID")
    @TableField("WORK_ARRANGE_")
    private String workarrangeId;

    @NotBlank(message = "排班人员ID",groups = {AddGroup.class})
    @ApiModelProperty(value = "排班人员ID")
    @TableField("MEMBER_ID_")
    private String memberId;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

}
