package com.artfess.manage.duty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyJobManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyJobDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyJobDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyJob;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 勤务岗位信息 服务实现类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-09
 */
@Service
public class CmgtDutyJobManagerImpl extends BaseManagerImpl<CmgtDutyJobDao, CmgtDutyJob> implements CmgtDutyJobManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;

    @Resource
    private CmgtDutyJobDtoMapper cmgtDutyJobDtoMapper;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtDutyJobDto> pageQuery(QueryFilter<CmgtDutyJob> queryFilter) {
        PageList<CmgtDutyJob> result = query(queryFilter);
        PageList<CmgtDutyJobDto> r = new PageList<CmgtDutyJobDto>(
                result.getRows().stream().map(e -> {
                            CmgtDutyJobDto t = cmgtDutyJobDtoMapper.toDto(e);


                            if (e.getCreateBy() != null) {
                                User user = userDao.selectById(e.getCreateBy());
                                if (user != null) {
                                    t.setCreateByName(user.getFullname());
                                }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtDutyJob t) {
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyJob t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtDutyJob t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtDutyJobDto dto) {
        CmgtDutyJob t = cmgtDutyJobDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtDutyJobDto dto) {
        CmgtDutyJob t = cmgtDutyJobDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }

    /**
     *
     * @return
     */
    public List<CmgtDutyJob> getJobs() {
        return this.cmgtDutyJobDao.selectList(null);
    }


}
