package com.artfess.manage.material.model;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 订单物资到货签收入库-明细表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Data
@ApiModel(value="CmgtMaterialSignWarehouseDetail对象", description="订单物资到货签收入库-明细表")
public class CmgtMaterialSignWarehouseDetail extends BaseModel<CmgtMaterialSignWarehouseDetail> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "到货签收单据_ID")
    @TableField("sign_warehouse_id_")
    private String signWarehouseId;

    @ApiModelProperty(value = "物资id")
    @TableField("material_id_")
    private String materialId;

    @ApiModelProperty(value = "品名")
    @TableField("name_")
    private String name;

    @ApiModelProperty(value = "型号")
    @TableField("model_")
    private String model;

    @ApiModelProperty(value = "计量单位（参考字典）")
    @TableField("unit_")
    private String unit;

    @ApiModelProperty(value = "计划采购数量（订单表）")
    @TableField("number_")
    private BigDecimal number;

    @ApiModelProperty(value = "到货实际数量（按实际到货输入，默认同订单表数量一直可调整）")
    @TableField("quantity_")
    private BigDecimal quantity;

    @ApiModelProperty(value = "实际采购单价（默认同基础数据一致）")
    @TableField("price_")
    private BigDecimal price;

    @ApiModelProperty(value = "单项采购金额")
    @TableField("amount_")
    private BigDecimal amount;

    @ApiModelProperty(value = "描述")
    @TableField("description_")
    private String description;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

}
