package com.artfess.manage.job;

import cn.hutool.core.util.RandomUtil;
import com.artfess.job.model.BaseJob;
import com.artfess.manage.base.dao.CmgtBasePositionDao;
import com.artfess.manage.base.model.CmgtBasePosition;
import com.artfess.manage.duty.dao.CmgtDutyJobDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleGpsinfoManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.dwd.dao.DwdSjBusDepartedDao;
import com.artfess.manage.dwd.dao.DwdSjCqEventDao;
import com.artfess.manage.dwd.dao.DwdSjFestivalHolidayDao;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjWeatherForcastMiManager;
import com.artfess.rocketmq.producer.RocketMQProducer;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import lombok.extern.slf4j.Slf4j;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Slf4j
@Service
public class CmgtLocationGeneratorJob extends BaseJob {

    @Resource
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrangeManager;

    @Resource
    private CmgtDutyVehicleGpsinfoManager cmgtDutyVehicleGpsinfoManager;

    @Resource
    private CmgtDutyJobDao cmgtDutyJobDao;

    @Resource
    private RocketMQProducer rocketMQProducer;

    protected Logger logger = LoggerFactory.getLogger(CmgtLocationGeneratorJob.class);

    @Resource
    private DwdSjWeatherForcastMiManager dwdSjWeatherForcastMiManager;

    @Resource
    private CmgtBasePositionDao cmgtBasePositionDao;

    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;

    @Resource
    private DwdSjBusDepartedDao dwdSjBusDepartedDao;

    @Resource
    private DwdSjCqEventDao dwdSjCqEventDao;


    @Resource
    private DwdSjFestivalHolidayDao dwdSjFestivalHolidayDao;


    public void executeJob(JobExecutionContext context) {
        //获取上下文参数。
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        log.info("===========jobDataMap============" + jobDataMap);
        //创建车辆位置模拟数据
        cmgtDutyVehicleGpsinfoManager.createSumilatedGpsData();
        //创建人员位置信息
        cmgtDutyWorkarrangeManager.createSumilatedTeamMemberLoationData();
        //创建事故易发点
        createAccidentPoint();

    }


    /**
     * 创建模拟事件易发点位
     */
    @Transactional
    private void createAccidentPoint() {
        QueryWrapper<CmgtBasePosition> queryWrapper = new QueryWrapper();
        queryWrapper.eq("DTYPE_", "ACCIDENT");
        queryWrapper.between("RECEIVE_TIME_", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 00:00:00",
                LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) + " 23:59:59");
        List<CmgtBasePosition> l = cmgtBasePositionDao.selectList(queryWrapper);
        if (l.size() < 3) {
            CmgtBasePosition position = new CmgtBasePosition();
            position.setDtype("ACCIDENT");
            position.setReceiveTime(LocalDateTime.now());
            position.setReceiveTime(LocalDateTime.now());
            position.setMemo("随机生成模拟数据");
            position.setLatitude(RandomUtil.randomBigDecimal(BigDecimal.valueOf(106.537288), BigDecimal.valueOf(106.55633)) + "");
            position.setLongitude(RandomUtil.randomBigDecimal(BigDecimal.valueOf(29.606626), BigDecimal.valueOf(29.615619)) + "");
            position.setName("事故易发点(" + (l.size() + 1) + ")");
            cmgtBasePositionDao.insert(position);
        }
    }


}
