package com.artfess.manage.dwd.manager.dto;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.artfess.base.entity.BaseModel;
import com.artfess.base.util.StringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.time.LocalDateTime;


/**
 * dwd_lk_epidemic_prevention_information
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-06
 */
@Data
@ApiModel(value = "DwdLkEpidemicPreventionInformationDto", description = "防疫信息填写DTO对象")
public class DwdLkEpidemicPreventionInformationDto extends BaseModel<DwdLkEpidemicPreventionInformationDto> {


    /**
     * 主建ID
     */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String name;


    /**
     * 手机号码
     */
    @ApiModelProperty(value = "手机号码")
    private String mobile;


    /**
     * 证件类型
     */
    @ApiModelProperty(value = "证件类型")
    private Integer type;

    private Object typeName;


    /**
     * 证件号
     */
    @ApiModelProperty(value = "证件号")
    private String idCard;


    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String sex;


    /**
     * 出生日期
     */
    @ApiModelProperty(value = "出生日期")
    private LocalDate dateOfBirth;


    /**
     * 是否入境人员
     */
    @ApiModelProperty(value = "是否入境人员")
    private Integer isEntry;


    /**
     * 既往行程\重点地区旅居史
     */
    @ApiModelProperty(value = "既往行程重点地区旅居史")
    private String journey;


    /**
     * 与确诊或疑似病例密切接触史
     */
    @ApiModelProperty(value = "与确诊或疑似病例密切接触史")
    private Integer contactHistory;


    /**
     * 是否居家隔离
     */
    @ApiModelProperty(value = "是否居家隔离")
    private Integer isIsolation;


    /**
     * 需要咨询或帮助
     */
    @ApiModelProperty(value = "需要咨询或帮助")
    private Integer help;


    /**
     * 住址
     */
    @ApiModelProperty(value = "住址",notes = "getAddressName")
    private String address;


    //{"detail":"车站","province":"河北省","city":"秦皇岛市","county":"北戴河区"}
    public String getAddressName() {
        if (StringUtil.isNotEmpty(this.address) && this.address.startsWith("{")) {
            JSONObject o = JSONUtil.parseObj(this.address);
            return o.getStr("province") + o.getStr("city") + o.getStr("county") + o.getStr("detail");
        }
        return this.address;
    }


    /**
     * 来源城市
     */
    @ApiModelProperty(value = "来源城市")
    private String city;


    /**
     * 来源地
     */
    @ApiModelProperty(value = "来源地",notes = "getFromAddressName")
    private String fromAddress;

    public String getFromAddressName() {
        if (StringUtil.isNotEmpty(this.fromAddress) && this.fromAddress.startsWith("{")) {
            JSONObject o = JSONUtil.parseObj(this.fromAddress);
            return o.getStr("province") + o.getStr("city") + o.getStr("county") + o.getStr("detail");
        }
        return this.fromAddress;
    }

    /**
     * 目的地/去向
     */
    @ApiModelProperty(value = "目的地/去向",notes = "getToAddressName")
    private String toAddress;

    public String getToAddressName() {
        if (StringUtil.isNotEmpty(this.toAddress) && this.toAddress.startsWith("{")) {
            JSONObject o = JSONUtil.parseObj(this.toAddress);
            return o.getStr("province") + o.getStr("city") + o.getStr("county") + o.getStr("detail");
        }
        return this.toAddress;
    }


    /**
     * 核酸报告
     */
    @ApiModelProperty(value = "核酸报告")
    private Integer report;

    private Object reportName;


    /**
     * 健康码
     */
    @ApiModelProperty(value = "健康码")
    private String code;


    /**
     * 状态
     */
    @ApiModelProperty(value = "状态")
    private Integer status;


    /**
     * 中转方式
     */
    @ApiModelProperty(value = "中转方式")
    private Integer transitMode;

    private Object transitModeName;


    /**
     * 登记时间
     */
    @ApiModelProperty(value = "登记时间")
    private LocalDateTime registerTime;


    /**
     * 放行时间
     */
    @ApiModelProperty(value = "放行时间")
    private LocalDateTime passTime;


    /**
     * 转运时间
     */
    @ApiModelProperty(value = "转运时间")
    private LocalDateTime transTime;


    /**
     * 抵渝日期
     */
    @ApiModelProperty(value = "抵渝日期")
    private LocalDate arriveTime;


    /**
     * 车次/航班号
     */
    @ApiModelProperty(value = "车次/航班号")
    private String trainNo;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String text;


    /**
     * 航空公司
     */
    @ApiModelProperty(value = "航空公司")
    private String airlineCompany;


    /**
     * 航班起飞时间
     */
    @ApiModelProperty(value = "航班起飞时间")
    private LocalDateTime takeOffTime;


    /**
     * 抵渝航班
     */
    @ApiModelProperty(value = "抵渝航班")
    private String airlineCode;


    /**
     * 是否有行李托运
     */
    @ApiModelProperty(value = "是否有行李托运")
    private Integer luggage;

    private Object luggageName;


    /**
     * 航站楼T2/T3
     */
    @ApiModelProperty(value = "航站楼T2/T3")
    private String terminal;


    /**
     * 要求
     */
    @ApiModelProperty(value = "要求")
    private String requirement;


    /**
     * 前往具体地址/航班、铁路目的地
     */
    @ApiModelProperty(value = "前往具体地址航班、铁路目的地",notes = "getInfoAddressName")
    private String infoAddress;

    public String getInfoAddressName() {
        if (StringUtil.isNotEmpty(this.infoAddress) && this.infoAddress.startsWith("{")) {
            JSONObject o = JSONUtil.parseObj(this.infoAddress);
            return o.getStr("province") + o.getStr("city") + o.getStr("county") + o.getStr("detail");
        }
        return this.infoAddress;
    }


    /**
     * 市内外
     */
    @ApiModelProperty(value = "市内外")
    private Integer inCity;

    private Object inCityName;


    /**
     * 转来方式
     */
    @ApiModelProperty(value = "转来方式")
    private String transInType;


    /**
     * 转走方式
     */
    @ApiModelProperty(value = "转走方式")
    private String transOutType;


    /**
     * 转运车牌号
     */
    @ApiModelProperty(value = "转运车牌号")
    private String transCarNumber;


    /**
     * 转运司机
     */
    @ApiModelProperty(value = "转运司机")
    private String transDriver;


    /**
     * 转运电话
     */
    @ApiModelProperty(value = "转运电话")
    private String transPhone;


    /**
     * 转运预计到达时间
     */
    @ApiModelProperty(value = "转运预计到达时间")
    private LocalDateTime transArrayTime;


    /**
     * 闭环类型
     */
    @ApiModelProperty(value = "闭环类型")
    private String transLoop;


    /**
     * 转运地址
     */
    @ApiModelProperty(value = "转运地址")
    private String transAddress;


    /**
     * 转运确认时间
     */
    @ApiModelProperty(value = "转运确认时间")
    private LocalDateTime transReceiveTime;


    /**
     * 删除标记
     */
    @ApiModelProperty(value = "删除标记")
    private Integer del;


    /**
     * 家庭成员JSON["id":1,"name":"姓名","idCard":"身份证号"]
     */
    @ApiModelProperty(value = "家庭成员",notes = "getFamilyMembersName")
    private String familyMembers;

    public String getFamilyMembersName() {
        if (StringUtil.isNotEmpty(this.familyMembers) && this.familyMembers.startsWith("[")) {
            JSONArray members = JSONUtil.parseArray(this.familyMembers);
            StringBuffer r = new StringBuffer();
            for (Object m : members) {
                JSONObject o = (JSONObject) m;
                r.append("姓名:").append(o.getStr("name"))
                        .append(" 证件号:").append(o.getStr("idCard"))
                        .append(" 电话:").append(o.getStr("phone")).append("\r\n");
            }
            return r.toString();
        }
        return this.familyMembers;
    }


    /**
     * 中转确认时间
     */
    @ApiModelProperty(value = "中转确认时间")
    private LocalDateTime turnConfirmTime;


    /**
     * 人数
     */
    @ApiModelProperty(value = "人数")
    private Integer amount;


    /**
     * 转运地区
     */
    @ApiModelProperty(value = "转运地区")
    private String transArea;


    /**
     * 接人地点
     */
    @ApiModelProperty(value = "接人地点")
    private String pickupPoint;


    /**
     * 等待时长
     */
    @ApiModelProperty(value = "等待时长")
    private Integer waitTime;


    private String createByName;


    /**
     * 创建人
     */
    @ApiModelProperty(value = "创建人")
    private Integer createUser;


    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private LocalDateTime insertTime;

    private LocalDateTime updateTime;

}
