package com.artfess.manage.duty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 车辆信息
 *
 * @author wjl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */

@Data
@ApiModel(value = "CmgtDutyVehicle对象", description = "车辆信息")
@FieldRepeat(fields = {"code", "name"}, message = "车牌号码或标识名称不能重复，请重新输入", groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyVehicle extends ManageBaseModel<CmgtDutyVehicle> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "车牌号码", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "车牌号码")
    @TableField("CODE_")
    private String code;

    @NotBlank(message = "标识名称", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "标识名称")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "车辆类型")
    @TableField("VEHICLE_TYPE_")
    private String vehicleType;

    @ApiModelProperty(value = "车辆品牌")
    @TableField("BRAND_")
    private String brand;

    @ApiModelProperty(value = "车辆颜色")
    @TableField("COLOR_")
    private String color;

    @ApiModelProperty(value = "购买日期")
    @TableField("PURCHASE_DATE_")
    private LocalDate purchaseDate;

    @ApiModelProperty(value = "燃油类型")
    @TableField("FUEL_TYPE_")
    private String fuelType;

    @ApiModelProperty(value = "用途")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

//    @TableLogic
//    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
//    @TableField("IS_DELE_")
//    private String isDele;

//    @ApiModelProperty(value = "创建人")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "修改人员")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "修改时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;

//    @ApiModelProperty(value = "版本号")
//    @TableField("VERSION_")
//    private Integer version;
//
//    @ApiModelProperty(value = "数据时间戳")
//    @TableField("LAST_TIME_")
//    private LocalDateTime lastTime;


    /** 管区 */
    @ApiModelProperty(value = "管区")
    @TableField("area_")
    private String area;

    @ApiModelProperty(value = "实时位置")
    @TableField("LOCATION_")
    private String location;

    @ApiModelProperty(value = "接收时间")
    @TableField("RECEIVE_TIME_")
    private LocalDateTime receiveTime;


    @ApiModelProperty(value = "状态")
    @TableField("STATUS_")
    private String status;


}
