package com.artfess.manage.duty.manager.dto;

import com.artfess.base.entity.AutoFillModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;



/**
 * cmgt_duty_org_workarrange
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-11
 */
@Data
@ApiModel(value="CmgtDutyOrgWorkarrangeDto", description="部门排班信息DTO对象")
public class CmgtDutyOrgWorkarrangeDto extends AutoFillModel<CmgtDutyOrgWorkarrangeDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 排班名称 */
    @ApiModelProperty(value = "排班名称")
    private String name;


    /** 排班小组 */
    @ApiModelProperty(value = "排班小组")
    private String teamId;




    /** 归属部门 */
    @ApiModelProperty(value = "归属部门")
    private String orgId;

    private String orgName;




    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;




    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;




    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    private Integer version;




    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;




}
