package com.artfess.manage.duty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.manage.duty.manager.CmgtDutyOrgWorkarrangeManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyOrgWorkarrangeDto;
import com.artfess.manage.duty.model.CmgtDutyOrgWorkarrange;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * 部门排班信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-11
 */
@Slf4j
@Api(tags = "部门排班信息")
@RestController
@RequestMapping("/manager/cmgtDutyOrgWorkarrange")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtDutyOrgWorkarrangeController extends BaseController<CmgtDutyOrgWorkarrangeManager, CmgtDutyOrgWorkarrange> {

    @Autowired
    private CmgtDutyOrgWorkarrangeManager cmgtDutyOrgWorkarrangeManager;


    @PostMapping(value="/pageQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询")
    public PageList<CmgtDutyOrgWorkarrangeDto> pageQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CmgtDutyOrgWorkarrange> queryFilter) {
        return cmgtDutyOrgWorkarrangeManager.pageQuery(queryFilter);
    }



    @PostMapping("/create")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtDutyOrgWorkarrangeDto t) {
        String result =  cmgtDutyOrgWorkarrangeManager.create(t);
        if (result == null) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "创建实体失败");
        }
        return new CommonResult<>(result);
    }


    @PutMapping("/update")
    @ApiOperation("更新实体的接口")
    public CommonResult<String> update(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtDutyOrgWorkarrangeDto t) {

        String result =  cmgtDutyOrgWorkarrangeManager.update(t);
        if (result == null) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>(result);
    }


    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result =  cmgtDutyOrgWorkarrangeManager.delete(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @GetMapping("/findAllOrgTree")
    @ApiOperation("获取所有维度下组织树信息")
    public List<Map<String,Object>> findAllOrgTree(){
        return cmgtDutyOrgWorkarrangeManager.getAllOrgTree();
    }

    @PostMapping("/findAll")
    public List<CmgtDutyOrgWorkarrange> findAll(){
        return cmgtDutyOrgWorkarrangeManager.findAll();
    }



}
