package com.artfess.manage.safty.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;

/**
 * cmgt_safty_appraisal
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyAppraisal对象", description="安全目标考核")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtSaftyAppraisal extends ManageBaseModel<CmgtSaftyAppraisal> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 所属部门 */
    @ApiModelProperty(value = "所属部门")
    @TableField("dept_id_")
    @NotBlank(message = "所属部门",groups = {AddGroup.class,UpdateGroup.class})
    private String deptId;

    /** 所属目标 */
    @ApiModelProperty(value = "所属目标")
    @TableField("target_id_")
    private String targetId;

    /** 所属计划 */
    @ApiModelProperty(value = "所属计划")
    @TableField("plan_task_id_")
    private String planTaskId;

    /** 责任人 */
    @ApiModelProperty(value = "责任人")
    @TableField("user_id_")
    @NotBlank(message = "责任人",groups = {AddGroup.class,UpdateGroup.class})
    private String userId;

    /** 任务工作情况 */
    @ApiModelProperty(value = "任务工作情况")
    @TableField("appraisal_detail_")
    private String appraisalDetail;

    /** 目标完成值 */
    @ApiModelProperty(value = "目标完成值")
    @TableField("appraisal_val_")
    private String appraisalVal;

    /** 任务完成时间 */
    @ApiModelProperty(value = "任务完成时间")
    @TableField("task_finish_date_")
    private LocalDate taskFinishDate;

    /** 考核结论 */
    @ApiModelProperty(value = "考核结论")
    @TableField("result_")
    private String result;

    /** 依据 */
    @ApiModelProperty(value = "依据")
    @TableField("according_")
    private String according;

    /** 考评人 */
    @ApiModelProperty(value = "考评人")
    @TableField("appraisal_user_")
    private String appraisalUser;

    /** 考核日期 */
    @ApiModelProperty(value = "考核日期")
    @TableField("appraisal_date_")
    private LocalDate appraisalDate;

    /** 附件 */
    @ApiModelProperty(value = "附件")
    @TableField("attachment_")
    private String attachment;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
