package com.artfess.manage.material.dao;

import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.type.JdbcType;

import java.util.List;

/**
 * 物资出入库明细 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-25
 */
public interface CmgtMaterialWarehouseInoutDetailDao extends BaseMapper<CmgtMaterialWarehouseInoutDetail> {

    @Select("select * from cmgt_material_warehouse_inout_detail where IS_DELE_='0' and WAREHOUSE_INOUT_ID_ = #{wid}")
    @Results({
            @Result(column="ID_", property="id", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="WAREHOUSE_INOUT_ID_", property="warehouseInoutId", jdbcType= JdbcType.VARCHAR),
            @Result(column="MATERIAL_INFO_ID_", property="materialInfoId", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="NAME_", property="name", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="MODEL_", property="model", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="QUANTITY_", property="quantity", jdbcType= JdbcType.VARCHAR, id=true),
            @Result(column="PRICE_", property="price", jdbcType= JdbcType.DECIMAL, id=true),
            @Result(column="AMOUNT_", property="amount", jdbcType= JdbcType.DECIMAL, id=true),
            @Result(column="SUPPLIER_", property="supplier", jdbcType= JdbcType.DECIMAL, id=true),
            @Result(column="DESCRIPTION_", property="description", jdbcType= JdbcType.DECIMAL, id=true)
    })
    public List<CmgtMaterialWarehouseInoutDetail> findMaterialDetailById(String wid);


    @Select("SELECT * FROM cmgt_material_warehouse_inout_detail b where b.QUANTITY_ID_ = #{quantityId}  " +
            "and exists(select * from cmgt_material_warehouse_inout a where a.ID_ = b.WAREHOUSE_INOUT_ID_ and a.DATA_TYPE_='0') " +
            " order by INOUT_DATE_")
    public List<CmgtMaterialWarehouseInoutDetail> findRKDeatilsByQuantityId(String quantityId);

}
