package com.artfess.manage.dwd;

import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.artfess.manage.utils.SignUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 黎沐华
 * @date 2022/8/30 9:42
 */
@Slf4j
@Component
public class DataCenterUtilTest {


    @Autowired
    private RestTemplate restTemplate;

    /**
     * ：国铁重庆北站-历史到达人数
     */
    private static String APPID = "b8fff05a_bf88_4391_8967_fa19364c";//b8fff05a_bf88_4391_8967_fa19364c
    private static String APPKEY = "38553d72d3a0480eb0aad7e9cfe4a48a"; //38553d72d3a0480eb0aad7e9cfe4a48a
    private static String APPURL = "http://222.180.171.219/api/oapigw/api/oapisvc/v1/aggapi/ab910d51287f445187b0cd2de850429b";
    //http://222.180.171.219/api/oapigw/api/oapisvc/automicApi/7fe4711997514f07b6726f9926dca53a


    /**
     * 发送事件中心方法
     *
     * @param obj 发送数据，对象需要经过 JSON.toJSONString 处理
     * @return 结果
     * @throws Exception 异常
     */
    public String send(String obj) throws Exception {

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);


        String appid = APPID;
        String timestamp = System.currentTimeMillis() + "";
        headers.add("timestamp", timestamp);
        headers.add("appid", appid);
        String appKey = APPKEY;

        Map<String, String> map = JSON.parseObject(obj, Map.class);

        String sign = SignUtils.generateSignature(map, appKey, SignUtils.SignType.HMACSHA256);
        headers.add("sign", sign);

        String uri = APPURL;
        HttpEntity<String> httpEntity = new HttpEntity<String>(obj, headers);
        log.info("事件上报,请求地址{}，入参：{}", uri, obj);
        //用HttpEntity封装整个请求报文
        ResponseEntity<String> result = restTemplate.postForEntity(uri, httpEntity, String.class);
        log.info("事件上报,响应: {}，{}", JSON.toJSONString(result.getBody()), JSON.toJSONString(result));

//        try {
//            //设备名称
//            rocketMQUtils.send(MqConstant.SEND_WARNING_TOPIC, JSON.toJSONString(deviceWarnInfoVo));
//        } catch (Exception e) {
//            log.error("发送失败:{}", e);
//        }
        return "";
    }

    public static void main(String[] args) throws Exception {
        String obj = "{\"startTime\":\"2020-06-01 00:00:00\",\"endTime\":\"2020-06-30 23:59:59\"}";

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        String timestamp = System.currentTimeMillis() + "";
        headers.add("timestamp", timestamp);
        headers.add("appid", APPID);
        Map<String, String> map = new HashMap<String,String>();
        map.put("timestamp", timestamp);
        map.put("appid", APPID);

        StringBuilder signBuilder = new StringBuilder().append("appid=").append(APPID).append("&")
                .append(obj).append("&")
                .append("timestamp=").append(timestamp).append("&")
                .append("key=").append(APPKEY);
        System.out.println("========signBuilder=============" + signBuilder);
        String sign = SignUtils.HMACSHA256(signBuilder.toString(), APPKEY);

        //String sign = SignUtils.generateSignature(map, APPKEY, SignUtils.SignType.HMACSHA256);

        System.out.println("========sign=============" + sign);
        //headers.add("sign", sign);
        map.put("sign", sign);

        String uri = APPURL; //+ "event_center/api/report_event";

        System.out.println("======= =====map=======" + HttpUtil.createPost(uri).contentType("application/json").addHeaders(map).body(obj));

        HttpResponse s = HttpUtil.createPost(uri).contentType("application/json").addHeaders(map).body(obj).execute();
//        HttpResponse s = cn.hutool.http.HttpUtil.createPost(uri).body(obj)
//                .addHeaders(headers.toSingleValueMap()).execute();
        //String s = HttpUtil.sendHttpRequest(uri,obj,"post");

        System.out.println("========sign===sssss==========" + s);

    }
}
