package com.artfess.manage.duty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 勤务队员信息
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
@Data
@ApiModel(value = "CmgtDutyTeamMember对象", description = "勤务队员信息")
@FieldRepeat(fields = {"code", "name"}, message = "编号或姓名不能重复，请重新输入", groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyTeamMember extends AutoFillModel<CmgtDutyTeamMember> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 归属部门
     */
    @ApiModelProperty(value = "归属部门")
    @TableField("ORG_ID_")
    private String orgId;

    @TableField(exist = false)
    private String orgName;


    @NotNull(message = "修改必须指定teamId", groups = {UpdateGroup.class})
    @ApiModelProperty(value = "所属小组")
    @TableField("TEAM_ID_")
    private String teamId;

    @TableField(exist = false)
    private CmgtDutyTeam cmgtDutyTeam;


    @NotBlank(message = "编号", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "编号")
    @TableField("CODE_")
    private String code;

    @NotBlank(message = "姓名", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "姓名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "职位")
    @TableField("POST_")
    private String post;

    @ApiModelProperty(value = "岗位")
    @TableField("JOB_")
    private String job;

    @ApiModelProperty(value = "性别")
    @TableField("SEX_")
    private String sex;

    @ApiModelProperty(value = "年龄")
    @TableField("AGE_")
    private Integer age;

    @NotBlank(message = "联系电话", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "联系电话")
    @TableField("PHONE_")
    private String phone;

    @NotBlank(message = "身份证号", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "身份证号")
    @TableField("IDCARD_")
    private String idcard;

    @ApiModelProperty(value = "技术情况")
    @TableField("SKILL_")
    private String skill;

    @ApiModelProperty(value = "是否正式员工")
    @TableField("ISZSYG_")
    private String iszsyg;

    @ApiModelProperty(value = "是否外派")
    @TableField("ISWP_")
    private String iswp;

    @ApiModelProperty(value = "外派部门")
    @TableField("DEPT_NAME_")
    private String deptName;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

//    @ApiModelProperty(value = "创建人机构ID")
//    @TableField("CREATE_ORG_ID_")
//    private String createOrgId;
//
//    @ApiModelProperty(value = "创建人")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "修改人员")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "修改时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;


    @ApiModelProperty(value = "实时位置")
    @TableField("LOCATION_")
    private String location;

    @ApiModelProperty(value = "接收时间")
    @TableField("RECEIVE_TIME_")
    private LocalDateTime receiveTime;



    @ApiModelProperty(value = "状态",notes = "TeamMemberStatusEnum")
    @TableField("STATUS_")
    private String status;


}
