package com.artfess.manage.duty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.manager.dto.CmgtDutyVehicleGpsinfoDto;
import com.artfess.manage.duty.model.CmgtDutyVehicleGpsinfo;

import java.util.List;

/**
 * 车辆GPS信息 服务类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-12
 */
public interface CmgtDutyVehicleGpsinfoManager extends BaseManager<CmgtDutyVehicleGpsinfo> {

    /**
     * 条件分页查询
     *
     * @param queryFilter
     * @return
     */
    PageList<CmgtDutyVehicleGpsinfoDto> pageQuery(QueryFilter<CmgtDutyVehicleGpsinfo> queryFilter);

    /**
     * 新增
     *
     * @param t
     * @return
     */
    String createInfo(CmgtDutyVehicleGpsinfo t);

    /**
     * 更新
     *
     * @param t
     * @return
     */
    String updateInfo(CmgtDutyVehicleGpsinfo t);

    /**
     * 删除
     *
     * @param t
     */
    void deleteInfo(CmgtDutyVehicleGpsinfo t);


    String create(CmgtDutyVehicleGpsinfoDto dto);

    String update(CmgtDutyVehicleGpsinfoDto dto);

    boolean delete(List<String> ids);


    /**
     * 创建随机模拟数据
     */
    public void createSumilatedGpsData();
}
