package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.DeviceWarnConfDetailsDao;
import com.artfess.device.base.manager.DeviceWarnConfDetailsManager;
import com.artfess.device.base.model.DeviceWarnConfDetails;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

/**
 * 设备告警配置详情 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceWarnConfDetailsManagerImpl extends BaseManagerImpl<DeviceWarnConfDetailsDao, DeviceWarnConfDetails> implements DeviceWarnConfDetailsManager {

    @Override
    public PageList<DeviceWarnConfDetails> query(QueryFilter<DeviceWarnConfDetails> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceWarnConfDetails> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<>(result);
    }

}
