package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.DeviceBaseContractDao;
import com.artfess.device.base.dao.DeviceRelationSupplierContractDao;
import com.artfess.device.base.manager.DeviceBaseContractManager;
import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceRelationSupplierContract;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 对合同信息进行管理 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Service
public class DeviceBaseContractManagerImpl extends BaseManagerImpl<DeviceBaseContractDao, DeviceBaseContract> implements DeviceBaseContractManager {

    @Resource
    private DeviceRelationSupplierContractDao deviceRelationSupplierContractDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveContract(DeviceBaseContract t) {

        int insert = this.baseMapper.insert(t);
        if(insert < 1){
            return false;
        }
        if(null != t.getRelationSupplierContract()) {
            DeviceRelationSupplierContract relationSupplierContract = t.getRelationSupplierContract();
            relationSupplierContract.setContractId(t.getId());
            deviceRelationSupplierContractDao.insert(relationSupplierContract);
        }

        return true;
    }

    @Override
    public DeviceBaseContract findById(String id) {
        DeviceBaseContract deviceBaseContract = this.baseMapper.selectById(id);
        if(null == deviceBaseContract) {
            return null;
        }
        QueryWrapper<DeviceRelationSupplierContract> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("CONTRACT_ID_", deviceBaseContract.getId());
        DeviceRelationSupplierContract contract = deviceRelationSupplierContractDao.selectOne(queryWrapper);
        deviceBaseContract.setRelationSupplierContract(contract);
        return deviceBaseContract;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateContract(DeviceBaseContract t) {
        int insert = this.baseMapper.updateById(t);
        if(insert < 1){
            return false;
        }
        QueryWrapper<DeviceRelationSupplierContract> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("CONTRACT_ID_", t.getId());
        deviceRelationSupplierContractDao.delete(queryWrapper);
        if(null != t.getRelationSupplierContract()) {
            DeviceRelationSupplierContract relationSupplierContract = t.getRelationSupplierContract();
            relationSupplierContract.setContractId(t.getId());
            deviceRelationSupplierContractDao.insert(relationSupplierContract);
        }

        return true;
    }

    @Override
    public PageList<DeviceBaseContract> findByPage(QueryFilter<DeviceBaseContract> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceBaseContract> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<DeviceBaseContract>(result);
    }
}
