package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.device.base.dao.DeviceBaseAreaDao;
import com.artfess.device.base.manager.DeviceBaseAreaManager;
import com.artfess.device.base.model.DeviceBaseArea;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 设备安装区域信息 例如：XX划片区域-->XX街道-->XX道路-->XX组团-->监测点 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Service
public class DeviceBaseAreaManagerImpl extends BaseManagerImpl<DeviceBaseAreaDao, DeviceBaseArea> implements DeviceBaseAreaManager {

    @Override
    public List<DeviceBaseArea> getTree(DeviceBaseArea entity) {
        QueryWrapper<DeviceBaseArea> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        if (StringUtils.isNotBlank(entity.getShortName())) {
            queryWrapper.like("short_name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByDesc("sn_");
        List<DeviceBaseArea> deviceAreaList = this.baseMapper.selectList(queryWrapper);
        List<DeviceBaseArea> tree = BeanUtils.listToTree(deviceAreaList);
        return tree;
    }
}
