package com.artfess.device.base.vo;


import com.artfess.device.base.model.DeviceVideoPoint;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 视频点位信息表（DEVICE_VIDEO_POINT）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-19
 */
@Data
@ApiModel(value="VideoPointVo对象", description="视频点位信息表VO")
public class VideoPointVo extends DeviceVideoPoint {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "摄像头类型【字典】（1：枪机，2：球机）")
    private String type;

    @ApiModelProperty(value = "视频点位图标")
    private String icon;

    @ApiModelProperty(value = "GIS区域标识")
    private String gisArea;

    @ApiModelProperty(value = "所属行政区划")
    private String addvcd;

    @ApiModelProperty(value = "所属区域（关联区域表ID）")
    private String areaId;

    @ApiModelProperty(value = "所属区域编码")
    private String areaCode;

    @ApiModelProperty(value = "所属区域名称")
    private String areaName;

    @ApiModelProperty(value = "安装地点类型【字典】（1：室外，2：室内）")
    private String addressType;

    @ApiModelProperty(value = "安装楼层【字典】（-2：负二楼，-1：负一楼，1：一楼、2：二楼、3：三楼）")
    private Integer floor;

    @ApiModelProperty(value = "产品类型编码")
    private String proTypeCode;

    @ApiModelProperty(value = "产品类型名称")
    private String proTypeName;

    @ApiModelProperty(value = "设备供应商")
    private String supplierCompanyId;

    @ApiModelProperty(value = "设备维护单位")
    private String repairCompanyId;

    @ApiModelProperty(value = "设备维护人员")
    private String repairUserId;

    @ApiModelProperty(value = "设备管理单位")
    private String managerCompanyId;

    @ApiModelProperty(value = "设备管理人员")
    private String managerUserId;

    @ApiModelProperty(value = "设备维护单位")
    private String repairCompanyName;

    @ApiModelProperty(value = "设备维护人员")
    private String repairUserName;

    @ApiModelProperty(value = "设备管理单位")
    private String managerCompanyName;

    @ApiModelProperty(value = "设备管理人员")
    private String managerUserName;
}
