package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.device.base.manager.AppraiseBaseManager;
import com.artfess.device.base.model.AppraiseBase;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 绩效考核-考核基本信息（device_appraise_base） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Slf4j
@RestController
@Api(tags = "绩效考核-考核基本信息")
@RequestMapping("/device/appraiseBase/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class AppraiseBaseController extends BaseController<AppraiseBaseManager, AppraiseBase> {

    @PostMapping("/saveBatch")
    @ApiOperation("批量保存实体的接口")
    public CommonResult<String> saveBatch(@ApiParam(name="model", value="实体集合") @RequestBody @Validated({AddGroup.class}) List<AppraiseBase> data) {
        boolean result = baseService.saveOrUpdateBatch(data);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }


    @PostMapping("/status")
    @ApiOperation("考核项状态")
    public CommonResult<String> publish(@ApiParam(name="model", value="实体信息") @RequestBody AppraiseBase t) {
        boolean result = baseService.publish(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

}
