package com.artfess.device.monitor.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.monitor.dao.DeviceDataHazardDao;
import com.artfess.device.monitor.manager.DeviceDataHazardManager;
import com.artfess.device.monitor.model.DeviceDataHazard;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.google.common.collect.Maps;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * 实时监控-危险源监控（DEVICE_DATA_HAZARD） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-08-01
 */
@Service
public class DeviceDataHazardManagerImpl extends BaseManagerImpl<DeviceDataHazardDao, DeviceDataHazard> implements DeviceDataHazardManager {
    @Override
    public CommonResult findByDeviceId(String productType,  QueryFilter<DeviceDataHazard> queryFilter) {
        Map<String, Object> data = Maps.newHashMap();
        data.put("productType", productType);

        PageBean pageBean = queryFilter.getPageBean();
        IPage<DeviceDataHazard> result = baseMapper.findByDeviceId(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        data.put("data", new PageList<DeviceDataHazard>(result));
        return CommonResult.success(data, "查询成功");
    }

    @Override
    @Transactional(readOnly=true)
    public PageList<DeviceDataHazard> query(QueryFilter<DeviceDataHazard> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        Class<DeviceDataHazard> currentModelClass = currentModelClass();
        IPage<DeviceDataHazard> result = baseMapper.findByDeviceId(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        return new PageList<DeviceDataHazard>(result);
    }
}
