package com.artfess.device.base.model;


import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModelProperty.AccessMode;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 绩效考核-考核详情（DEVICE_APPRAISE_DETAILS）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Data
@TableName("device_appraise_details")
@ApiModel(value="DeviceAppraiseDetails对象", description="绩效考核-考核详情（DEVICE_APPRAISE_DETAILS）")
public class AppraiseDetails extends AutoFillModel<AppraiseDetails> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定考核详情id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写考核ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核ID")
    @TableField("info_id_")
    private String infoId;

    @NotBlank(message = "请填写考核项ID",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核项ID")
    @TableField("item_id_")
    private String itemId;

    @ApiModelProperty(value = "考核项内容")
    @TableField("item_")
    private String item;

    @ApiModelProperty(value = "考核项评分")
    @TableField("item_score_")
    private BigDecimal itemScore;

    @ApiModelProperty(value = "考核项得分(换算后的得分)")
    @TableField("item_result_")
    private BigDecimal itemResult;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode=AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

}
