package com.artfess.device.base.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 绩效考核-考核基本信息（device_appraise_base）
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Data
@TableName("device_appraise_base")
@ApiModel(value="DeviceAppraiseBase对象", description="绩效考核-考核标准（device_appraise_base）")
public class AppraiseBase extends AutoFillModel<AppraiseBase> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定考核标准id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键ID")
    @TableId(value = "id_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请填写考核标题",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核标题")
    @TableField("ASSESS_TITLE_")
    private String assessTitle;

    @NotBlank(message = "请填写考核方式",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核方式【字典】（1：单位考核，2：合同考核）")
    @TableField("assess_type_")
    private String assessType;

    @NotNull(message = "请填写考核方式",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "考核年度")
    @TableField("ASSESS_YEAR_")
    private Integer assessYear;

    @ApiModelProperty(value = "考核说明")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "发布状态【字典】（0：未发布 ，1：已发布）")
    @TableField("publish_status_")
    private String publishStatus;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

    @TableField(exist = false)
    @ApiModelProperty("考核项信息数据")
    private List<AppraiseItems> itemsList;

}
