package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.device.base.dao.DeviceInfoDao;
import com.artfess.device.base.dao.DeviceProductInfoDao;
import com.artfess.device.base.dao.DeviceProductTypeDao;
import com.artfess.device.base.manager.DeviceProductTypeManager;
import com.artfess.device.base.model.DeviceProductInfo;
import com.artfess.device.base.model.DeviceProductType;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 设备产品类型信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceProductTypeManagerImpl extends BaseManagerImpl<DeviceProductTypeDao, DeviceProductType> implements DeviceProductTypeManager {

    @Resource
    private DeviceProductInfoDao productInfoDao;

    @Resource
    private DeviceInfoDao deviceInfoDao;

    @Override
    public List<DeviceProductType> getTree(DeviceProductType entity) {
        QueryWrapper<DeviceProductType> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByDesc("sn_");
        List<DeviceProductType> deviceAreaList = this.baseMapper.selectList(queryWrapper);
        List<DeviceProductType> tree = BeanUtils.listToTree(deviceAreaList);
        return tree;
    }

    @Override
    public List<DeviceProductType> getAllTree(DeviceProductType entity) {
        QueryWrapper<DeviceProductType> queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank(entity.getCode())) {
            queryWrapper.like("code_", entity.getCode());
        }

        if (StringUtils.isNotBlank(entity.getName())) {
            queryWrapper.like("name_", entity.getName());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByDesc("sn_");
        List<DeviceProductType> deviceAreaList = this.baseMapper.selectList(queryWrapper);
        DeviceProductType video =new DeviceProductType();
        video.setId("100");
        video.setCode("video");
        video.setName("摄像头");
        video.setParentId("1552911478301003776");
        video.setHasChildren(0);
        video.setIsDele("0");
        video.setSn(100);
        deviceAreaList.add(video);
        List<DeviceProductType> tree = BeanUtils.listToTree(deviceAreaList);
        return tree;
    }

    @Override
    @Transactional
    public String updateProductType(DeviceProductType t) {

        DeviceProductType productType = this.baseMapper.selectById(t.getId());
        String oldName = productType.getName();

        QueryWrapper<DeviceProductInfo> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("type_id_", productType.getId());
        List<DeviceProductInfo> deviceProductInfos = productInfoDao.selectList(queryWrapper);
        deviceProductInfos.forEach(productInfo -> {
            productInfo.setFullName(productInfo.getFullName().replace(oldName, t.getName()));
            this.productInfoDao.updateById(productInfo);
        });

        return this.updateTree(t, oldName);
    }

}
