package com.artfess.device.base.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dao.AppraiseItemsDao;
import com.artfess.device.base.manager.AppraiseBaseManager;
import com.artfess.device.base.manager.AppraiseItemsManager;
import com.artfess.device.base.model.AppraiseItems;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 绩效考核-考核项目信息（DEVICE_APPRAISE_ITEMS） 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Service
public class AppraiseItemsManagerImpl extends BaseManagerImpl<AppraiseItemsDao, AppraiseItems> implements AppraiseItemsManager {

    @Autowired
    private AppraiseBaseManager standardManager;

    @Override
    public PageList<AppraiseItems> query(QueryFilter<AppraiseItems> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        QueryWrapper<AppraiseItems> queryWrapper = convert2Wrapper(queryFilter, currentModelClass());
        queryWrapper.orderByAsc("item_sn_");
        IPage<AppraiseItems> result = baseMapper.queryPage(convert2IPage(pageBean), queryWrapper);
        return new PageList<>(result);
    }


    @Override
    public boolean save(AppraiseItems t) {
        throw new RuntimeException("该方法已禁用，随考核基本信息保存。");
    }

    @Override
    public boolean updateById(AppraiseItems t) {
        throw new RuntimeException("该方法已禁用，随考核基本信息保存。");
    }

}
