package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.base.model.DeviceStatusLog;
import com.artfess.device.base.vo.DeviceStatusTimeVo;
import com.artfess.device.base.vo.StatisticsVo;

import java.util.List;

/**
 * 设备状态日志 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceStatusLogManager extends BaseManager<DeviceStatusLog> {

    /**
     * 设备状态日志统计，按状态和时间统计
     * @param dto 参数
     * @return 结果
     */
    List<StatisticsVo> statistics(StatisticsDto dto);

    /**
     * 状态统计下钻
     * @param dto 参数
     * @return 结果
     */
    List<StatisticsVo> statisticsSub(StatisticsDto dto);

    /**
     * 设备故障次数统计
     * @param dto 参数
     * @return 结果
     */
    List<StatisticsVo> statisticsTrouble(StatisticsDto dto);

    /**
     * 当前设备故障次数统计
     * @return 结果
     */
    List<StatisticsVo> statisticsCurrentTrouble();

    /**
     * 各月份设备故障数
     * @return 结果
     */
    List<StatisticsVo> troubleCountMonthly();

    /**
     * 分页获取设备时长统计
     * @param queryFilter
     * @return
     */
    PageList<DeviceStatusTimeVo> timeStatistics(QueryFilter<DeviceStatusLog> queryFilter);
}
