package com.artfess.device.base.dao;

import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.vo.DeviceCountVo;
import com.artfess.device.base.vo.FailureDeviceCountVo;
import com.artfess.device.base.vo.HomeRealTimeVo;
import com.artfess.device.base.vo.StatisticsVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 设备信息 Mapper 接口
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-15
 */
public interface DeviceInfoDao extends BaseMapper<DeviceInfo> {

    List<DeviceInfo> findByParams(@Param("vo") DeviceInfo entity);

    IPage<DeviceInfo> findByProductType(IPage<DeviceInfo> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<DeviceInfo> convert2Wrapper);

    String getAreaName(@Param("addvcd") String addvcd);

    List<DeviceCountVo>countNum(@Param("productId") String productId);

    List<DeviceInfo> findDeviceList(@Param("productType") String productType);

    IPage<FailureDeviceCountVo> failureStatistics(IPage<DeviceInfo> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<DeviceInfo> convert2Wrapper);

    IPage<DeviceInfo> findByPage(IPage<DeviceInfo> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<DeviceInfo> convert2Wrapper);

    IPage<DeviceInfo> failureEquipment(IPage<DeviceInfo> convert2IPage, @Param(Constants.WRAPPER) QueryWrapper<DeviceInfo> convert2Wrapper);

    /**
     * 根据设备标识查询设备信息
     *
     * @param deviceCode 设备标识
     * @Return: java.util.List<com.artfess.bzzgj.device.model.DeviceInfo>
     * @Author: chens
     * @Date: 2022/9/7 16:30
     */
    DeviceInfo findByDeviceCode(@Param("deviceCode") String deviceCode);

    List<DeviceInfo> currentStatusAnalyze();

    List<HomeRealTimeVo> homeRealTime(@Param("table") String table, @Param("code") String code);

    List<StatisticsVo> monthlyAnalyze(@Param("code") String code);

    List<StatisticsVo> monthlyVideoAnalyze();
}
