package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.device.base.manager.AppraiseDetailsManager;
import com.artfess.device.base.model.AppraiseDetails;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 绩效考核-考核详情（DEVICE_APPRAISE_DETAILS） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Slf4j
@RestController
@Api(tags = "绩效考核-考核详情")
@RequestMapping("/device/appraiseDetails/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class AppraiseDetailsController extends BaseController<AppraiseDetailsManager, AppraiseDetails> {

    @PostMapping("/saveBatch")
    @ApiOperation("批量保存实体的接口")
    public CommonResult<String> saveBatch(@ApiParam(name="model", value="实体集合") @RequestBody @Validated({AddGroup.class}) List<AppraiseDetails> data) {
        boolean result = baseService.saveOrUpdateBatch(data);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

}
