package com.artfess.rest.auth.service;


import com.artfess.base.cache.annotation.Cacheable;
import com.artfess.base.constants.CacheKeyConst;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.security.MethodAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;

/**
 * 其他服务模块需要引用这个包  这个包是从portal 服务模块中获取url的认证信息
 *
 * @author liyg
 * @Primary 不能删除
 */
@Service
public class RestMethodAuthService implements MethodAuthService {
    private static Logger logger = LoggerFactory.getLogger(RestMethodAuthService.class);
    @Autowired
    SystemConfigFeignService systemConfigFeignService;

    @Cacheable(value = CacheKeyConst.EIP_SYS_METHOD_AUTH, key = CacheKeyConst.EIP_SYS_METHOD_AUTH_KEY, pureKey = true)
    @Override
    public List<HashMap<String, String>> getMethodAuth() {
        List<HashMap<String, String>> methodRoleAuth = systemConfigFeignService.getMethodRoleAuth();
        logger.debug(" portalFeign " + methodRoleAuth);
        return methodRoleAuth;
    }
}
