/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.redis.util;

import com.artfess.base.enums.CodePrefix;
import com.artfess.redis.util.RedisUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class CodeCreatorUtil {
    @Resource
    private RedisUtil redisUtil;

    private String createCode(String key, String prefix, int length) {
        if (StringUtils.isEmpty((Object)key) || length < 1) {
            return null;
        }
        Long lon = this.redisUtil.incr(key, 1L);
        StringBuilder sb = new StringBuilder(prefix);
        int sy = length - sb.length() - String.valueOf(lon).length();
        if (sy > 0) {
            for (int i = 0; i < sy; ++i) {
                sb.append("0");
            }
        }
        sb.append(lon);
        return sb.toString();
    }

    private String createCode(String key, String prefix, int length, String format) {
        int sy;
        if (StringUtils.isEmpty((Object)key) || length < 1) {
            return null;
        }
        Long lon = this.redisUtil.incr(key, 1L);
        StringBuilder sb = new StringBuilder(prefix);
        if (!StringUtils.isEmpty((Object)format)) {
            Date now = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
            String fmt = simpleDateFormat.format(now);
            sb.append(fmt);
        }
        if ((sy = length - sb.length() - String.valueOf(lon).length()) > 0) {
            for (int i = 0; i < sy; ++i) {
                sb.append("0");
            }
        }
        sb.append(lon);
        return sb.toString();
    }

    public String createCode(CodePrefix codePrefix, int sequenceLength) {
        return this.createCode(codePrefix.getKey(), codePrefix.getPrefix(), sequenceLength);
    }

    public String createCodeYYYYMMDD(CodePrefix codePrefix, int sequenceLength) {
        return this.createCode(codePrefix.getKey(), codePrefix.getPrefix(), sequenceLength, "yyyyMMdd");
    }
}

