package com.artfess.file.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.file.params.FlowUploadPropertiesStorageDTO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import javax.annotation.Resource;

import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.file.model.FlowUploadProperties;
import com.artfess.file.persistence.manager.FlowUploadPropertiesManager;

/**
 * 
 * <pre> 
 * 描述：流程附件上传配置 控制器类
 * 构建组：x7
 * 作者:zhangxw
 * 邮箱:zhangxw@jee-soft.cn
 * 日期:2020-06-01 20:53:49
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value="/file/flowUploadProperties/v1")
@Api(tags = "流程附件存储配置")
@ApiGroup(group = {ApiGroupConsts.GROUP_BPM})
public class FlowUploadPropertiesController extends BaseController<FlowUploadPropertiesManager,FlowUploadProperties>{
	@Resource
	FlowUploadPropertiesManager flowUploadPropertiesManager;
	
	/**
	 * 流程附件上传配置列表(分页条件查询)数据
	 */
	@PostMapping("/listJson")
	@ApiOperation(value="流程附件上传配置数据列表", httpMethod = "POST", notes = "获取流程附件上传配置列表")
	public PageList<FlowUploadProperties> list(@ApiParam(name="queryFilter",value="查询对象")@RequestBody QueryFilter queryFilter) throws Exception{
		return flowUploadPropertiesManager.query(queryFilter);
	}
	
	/**
	 * 流程附件上传配置明细页面
	 * @param id
	 * @return
	 * @throws Exception 
	 * ModelAndView
	 */
	@GetMapping(value="/getJson")
	@ApiOperation(value="流程附件上传配置数据详情",httpMethod = "GET",notes = "流程附件上传配置数据详情")
	public FlowUploadProperties get(@ApiParam(name="id",value="业务对象主键", required = true)@RequestParam String id) throws Exception{
		return flowUploadPropertiesManager.get(id);
	}
	
    /**
	 * 新增流程附件上传配置
	 * @param flowUploadProperties
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@PostMapping(value="save")
	@ApiOperation(value = "新增,更新流程附件上传配置数据", httpMethod = "POST", notes = "新增,更新流程附件上传配置数据")
	public CommonResult<String> save(@ApiParam(name="flowUploadProperties",value="流程附件上传配置业务对象", required = true)@RequestBody FlowUploadProperties flowUploadProperties) throws Exception{
		String msg = "添加流程附件上传配置成功";
		CommonResult<String> validateResult = isExist(flowUploadProperties.getId(), flowUploadProperties.getFlowKey(), flowUploadProperties.getFlowName());
		if(!validateResult.getState()){
			return validateResult;
		}
		if(StringUtil.isEmpty(flowUploadProperties.getId())){
			if(StringUtil.isNotEmpty(flowUploadProperties.getFlowKey())){
				flowUploadProperties.setFlowKey(","  +flowUploadProperties.getFlowKey()+ ",");
				flowUploadProperties.setFlowName(","  +flowUploadProperties.getFlowName()+ ",");
			}
			flowUploadPropertiesManager.create(flowUploadProperties);
		}else{
			if(StringUtil.isNotEmpty(flowUploadProperties.getFlowKey())){
				if(!flowUploadProperties.getFlowKey().startsWith(",")){
					flowUploadProperties.setFlowKey(","  +flowUploadProperties.getFlowKey());
					flowUploadProperties.setFlowName(","  +flowUploadProperties.getFlowName());
				}
				if(!flowUploadProperties.getFlowKey().endsWith(",")){
					flowUploadProperties.setFlowKey(flowUploadProperties.getFlowKey()+ ",");
					flowUploadProperties.setFlowName(flowUploadProperties.getFlowName()+ ",");
				}
			}
			flowUploadPropertiesManager.update(flowUploadProperties);
			 msg = "更新流程附件上传配置成功";
		}
		return new CommonResult<String>(msg);
	}
	
	/**
	 * 判断流程key在其他配置中是否已存在
	 * @param id
	 * @param flowKeys
	 * @return
	 */
	private CommonResult<String> isExist(String id,String flowKeys,String flowNames){
		if(StringUtil.isNotEmpty(flowKeys)){
			String[] flowKeyArray = flowKeys.split(",");
			String[] flowNameArray = flowNames.split(",");
			boolean exist = false;
			String existFlowNames = "";
			for (int i = 0; i < flowKeyArray.length; i++) {
				String flowKey = flowKeyArray[i];
				if(StringUtil.isNotEmpty(flowKey)){
					FlowUploadPropertiesStorageDTO properties = flowUploadPropertiesManager.getByFlowKey(flowKey);
					if(BeanUtils.isNotEmpty(properties) && (StringUtil.isEmpty(id) || !properties.getId().equals(id))){
						exist = true;
						if(StringUtil.isNotEmpty(existFlowNames)){
							existFlowNames += "，";
						}
						existFlowNames += flowNameArray[i];
					}
				}
			}
			if(exist){
				return new CommonResult<String>(false, "保存失败！流程【"+existFlowNames+"】在其他配置中已存在，不能重复配置。");
			}
		}
		return new CommonResult<String>(true, "");
	}
	
	/**
	 * 批量删除流程附件上传配置记录
	 * @param ids
	 * @throws Exception 
	 * @return
	 * @exception 
	 */
	@DeleteMapping(value="/remove")
	@ApiOperation(value = "批量删除流程附件上传配置记录", httpMethod = "DELETE", notes = "批量删除流程附件上传配置记录")
	public CommonResult<String> removes(@ApiParam(name="ids",value="业务主键数组,多个业务主键之间用逗号分隔", required = true)@RequestParam String...ids) throws Exception{
		flowUploadPropertiesManager.removeByIds(ids);
		return new CommonResult<String>(true, "批量删除成功");
	}
	
	@GetMapping(value="/getByFlowKey")
	@ApiOperation(value="根据流程key获取",httpMethod = "GET",notes = "根据流程key获取")
	public CommonResult<FlowUploadPropertiesStorageDTO> getByFlowKey(@ApiParam(name="flowKey",value="业务对象主键", required = true)@RequestParam String flowKey) throws Exception{
		FlowUploadPropertiesStorageDTO properties = flowUploadPropertiesManager.getByFlowKey(flowKey);
		if(BeanUtils.isNotEmpty(properties)){
			return new CommonResult<FlowUploadPropertiesStorageDTO>(true, "获取成功！", properties);
		}
		return new CommonResult<FlowUploadPropertiesStorageDTO>(false, "根据流程key未获取到上次配置！");
	}
}
