package com.artfess.security.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.security.manager.SysAuthorizationManager;
import com.artfess.security.model.SysAuthorization;
import com.artfess.security.util.AuthorCheck;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;

/**
 * <pre>
 * 描述： 控制器类
 * 构建组：x7
 * 作者:pangq
 * 邮箱:pangq@jee-soft.cn
 * 日期:2020-07-06 15:25:12
 * 版权：广州宏天软件股份有限公司
 * </pre>
 */
@RestController
@RequestMapping(value = "/uc/AuthorizationModel/v1")
@Api(tags = "系统版权授权")
@ApiGroup(group = {ApiGroupConsts.GROUP_UC})
public class SysAuthorizationController extends BaseController<SysAuthorizationManager, SysAuthorization> {

    /**
     * 项目根目录
     */
    public static final String ROOT_PATH = System.getProperty("user.dir");

    /**
     * 模板下载、文件导入临时文件目录名
     */
    public static final String DATA_TEMP_FILE = "tempFile";

    /**
     * 模板下载、文件导入临时文件目录
     */
    public static final String TEMP_DATA_EXCEL = ROOT_PATH + File.separator + DATA_TEMP_FILE;

    @Resource
    SysAuthorizationManager systemAuthorizationManager;

    @Autowired
    private AuthorCheck authorCheck;

    /**
     * 列表(分页条件查询)数据
     *
     * @param queryFilter
     * @return
     * @throws Exception PageJson
     * @throws
     */
    @PostMapping("/listJson")
    @ApiOperation(value = "数据列表", httpMethod = "POST", notes = "获取列表")
    public PageList<SysAuthorization> list(@ApiParam(name = "queryFilter", value = "查询对象") @RequestBody QueryFilter<SysAuthorization> queryFilter) throws Exception {
        List<FieldSort> sorter = queryFilter.getSorter();
//		sorter.add(new FieldSort("ID_", Direction.DESC));
        queryFilter.setSorter(sorter);
        return systemAuthorizationManager.query(queryFilter);
    }

    /**
     * 明细页面
     *
     * @param id
     * @return
     * @throws Exception ModelAndView
     */
    @GetMapping(value = "/getJson")
    @ApiOperation(value = "数据详情", httpMethod = "GET", notes = "数据详情")
    public SysAuthorization get(@ApiParam(name = "id", value = "业务对象主键", required = true) @RequestParam String id) throws Exception {
        return systemAuthorizationManager.get(id);
    }

    /**
     * 新增
     *
     * @return
     * @throws Exception
     * @throws
     */
    @PostMapping(value = "save")
    @ApiOperation(value = "新增,更新数据", httpMethod = "POST", notes = "新增,更新数据")
    public CommonResult<String> save(@ApiParam(name = "SysSystemAuthorization", value = "业务对象", required = true) @RequestBody SysAuthorization sysAuthorization) throws Exception {
        String msg = "添加成功";
        if (StringUtil.isEmpty(sysAuthorization.getId())) {
            systemAuthorizationManager.create(sysAuthorization);
        } else {
            systemAuthorizationManager.update(sysAuthorization);
            msg = "更新成功";
        }
        return new CommonResult<String>(msg);
    }

    /**
     * 批量删除记录
     *
     * @param ids
     * @return
     * @throws Exception
     * @throws
     */
    @DeleteMapping(value = "/remove")
    @ApiOperation(value = "批量删除记录", httpMethod = "DELETE", notes = "批量删除记录")
    public CommonResult<String> removes(@ApiParam(name = "ids", value = "业务主键数组,多个业务主键之间用逗号分隔", required = true) @RequestParam String... ids) throws Exception {
        systemAuthorizationManager.removeByIds(ids);
        return new CommonResult<String>(true, "删除成功");
    }

    @PostMapping(value = "/downloadFileLic")
    @ApiOperation("客户生成并下载系统信息lic文件")
    public void downloadFileLic(HttpServletResponse response) throws Exception {

        String path = this.systemAuthorizationManager.systemCreateFile();
        if (StringUtils.isEmpty(path)) {
            //throw new ApplicationException("下载授权文件出错");
        }
        File file = new File(path);
        HttpUtil.downLoadFile(response, path, file.getName());

    }

    //上传授权文件读取内容覆盖原授权内容
    @PostMapping(value = "/uploadFileLic")
    @ApiOperation("管理员上传客户发过来的授权文件")
    public CommonResult<String> uploadFileLic(@ApiParam(name = "file", value = "上传的文件流") @RequestBody MultipartFile file, HttpServletResponse response) {
        try {

            String filePath = TEMP_DATA_EXCEL;
            File upload = new File(filePath);
            if (!upload.exists() && !upload.isDirectory()) {
                upload.mkdirs();
            }
            File dest = new File(TEMP_DATA_EXCEL + File.separator + ".lic");
            try {
                file.transferTo(dest);
            } catch (FileNotFoundException e) {
                return new CommonResult<>(false, "没有找到授权文件：" + e.getMessage());
            } catch (IOException e) {
                return new CommonResult<>(false, "没有找到授权文件：" + e.getMessage());
            }
            //读取文件信息到数据库中
            SysAuthorization entity = authorCheck.redFileToObject(dest);
            QueryWrapper<SysAuthorization> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("DEPT_NAME_", entity.getDeptName());

            SysAuthorization systemAuthorization = this.systemAuthorizationManager.getOne(queryWrapper);
            if (systemAuthorization != null) {
                entity.setId(systemAuthorization.getId());
            }
            this.systemAuthorizationManager.saveOrUpdate(entity);
            return new CommonResult<>(true, "上传成功");
        } catch (Exception e) {
            return new CommonResult<>(false, e.getMessage());
        }
    }

    @PostMapping(value = "/downloadAuthorizationFile")
    @ApiOperation("下载授权文件")
    @ApiImplicitParam(name = "id", value = "id", required = true)
    public void downloadAuthorizationFile(HttpServletResponse response, HttpServletRequest request, String id) throws Exception {
        String path = this.systemAuthorizationManager.createDesFile(id);
        File file = new File(path);
        HttpUtil.downLoadFile(response, path, file.getName());
    }

    //上传授权文件读取内容覆盖原授权内容
    @PostMapping(value = "/uploadAuthorizationFile")
    @ApiOperation("上传授权文件")
    public CommonResult<String> uploadAuthorizationFile(HttpServletResponse response, @ApiParam(name = "file", value = "上传的文件流") @RequestBody MultipartFile file) {
        try {

            //MultipartFile file = request.getFile("file");
            String filePath = TEMP_DATA_EXCEL;
            File upload = new File(filePath);
            if (!upload.exists() && !upload.isDirectory()) {
                upload.mkdirs();
            }
            File dest = new File(AuthorCheck.FILE_PATH);
            try {
                file.transferTo(dest);
            } catch (IOException e) {
                return new CommonResult<>(false, e.getMessage());
            }
            return new CommonResult<>(true, "上传成功");
        } catch (Exception e) {
            return new CommonResult<>(false, e.getMessage());
        }
    }

    private boolean checkExt(String fileExt) {
        String[] types = new String[]{"data", "lic"};//permissibleTypes.split(",");
        for (String type : types) {
            if (fileExt.toLowerCase().endsWith(type.toLowerCase())) {
                return true;
            }
        }
        return false;
    }

    @PostMapping(value = "/querySystemAuthorization")
    @ApiOperation("查询授权信息")
    public SysAuthorization querySystemAuthorization() {
        try {
            //Map<String,String> data=AuthorCheck.getMapInfo();
            SysAuthorization resultCode = authorCheck.redFileToObject();
            return resultCode;
        } catch (Exception e) {
            return null;
        }
    }

    @PostMapping(value = "/checkSystemAuthorization")
    @ApiOperation("登录页判断是否显示上传授权码按钮")
    public CommonResult<String> checkSystemAuthorization() {
        try {
            String resultCode = authorCheck.newCheck();
            return new CommonResult<>(true, resultCode);
        } catch (Exception e) {
            return new CommonResult<>(false, e.getMessage());
        }
    }

    @PostMapping(value = "/systemStartCreateFile")
    @ApiOperation("系统启动的时候默认生成一个临时授权文件")
    public void systemStartCreateFile() throws Exception {
         this.systemAuthorizationManager.systemStartCreateFile();
    }
}
