package com.artfess.base.enums;

import lombok.Getter;
import lombok.NoArgsConstructor;

/**
 * 业务编码key
 *
 * @Author : min.wu
 * @Date: 2021/09/07 10:51
 */
@NoArgsConstructor
@Getter
public enum CodePrefix {
    /**
     * 申请单编码
     */
    PURCHASING("bmp:purchasing:code", "P", "申请单编码"),
    /**
     * 采购计划编码
     */
    ORDER("bmp:order:code", "O", "采购计划编码"),

    /**
     * 签收入库收据号
     */
    SIGN_WAREHOUSE("bmp:sign:code", "S", "签收入库收据号"),
    ;

    private String key;
    private String prefix;
    private String desc;

    CodePrefix(String key, String prefix, String desc) {
        this.key = key;
        this.prefix = prefix;
        this.desc = desc;
    }


}
