package com.artfess.uc.api.impl.context;

import com.artfess.base.annotation.IgnoreOnAssembly;
import com.artfess.base.constants.TenantConstant;
import com.artfess.base.context.BaseContext;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.ContextThread;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import org.springframework.context.annotation.Primary;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;



/**
 * 微服务部署时 非uc模块将使用该bean
 * @author liyanggui
 *
 */
@Service
@IgnoreOnAssembly
@Primary
public class UcimplContext implements BaseContext, ContextThread {

	private ThreadLocal<String> tempTenantId = new ThreadLocal<>();

	public void setTempTenantId(String tenantId) {
		tempTenantId.set(tenantId);
	}

	public void clearTempTenantId() {
		this.tempTenantId.remove();
	}

	@Override
	public String getCurrentUserId() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentUserId();
	}

	@Override
	public String getCurrentUserAccout() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentUser().getAccount();
	}

	@Override
	public String getCurrentUserName() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentUser().getFullname();
	}

	@Override
	public String getCurrentOrgId() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentOrgId();
		//return ContextUtil.getCurrentGroupId();
	}

	@Override
	public String getCurrentOrgName() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentOrgName();
	}

	@Override
	public String getCurrentDeptId() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentDeptId();
	}

	@Override
	public String getCurrentDeptName() {
		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}
		return ContextUtil.getCurrentDeptName();
	}

	@Override
	public String getCurrentTenantId() {
		String tenantId = HttpUtil.getTenantId();
		if(BeanUtils.isNotEmpty(tenantId)) {
			return tenantId;
		}

		String tempTenantId = this.tempTenantId.get();
		if (StringUtil.isNotEmpty(tempTenantId)) {
			return tempTenantId;
		}

		if(authenticationEmpty()) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}

		IUser currentUser = ContextUtil.getCurrentUser();
		if(BeanUtils.isEmpty(currentUser)) {
			return TenantConstant.PLATFORM_TENANT_ID;
		}

		return currentUser.getTenantId();
	}

	/**
	 * 兼容单元测试
	 * @return
	 */
	private boolean authenticationEmpty() {
		Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
		if(BeanUtils.isEmpty(authentication) || authentication instanceof AnonymousAuthenticationToken) {
			return true;
		}
		return false;
	}

	@Override
	public void cleanAll() {
		clearTempTenantId();
	}

}
