let sidebardialog = {
  code: `<template>
  <div>
    <div class="block">
      <el-form ref="form" :model="formSetting" label-width="160px">
        <el-form-item label="设置对话框的宽度(单位%)">
          <el-slider v-model="formSetting.dialogWidth" show-input></el-slider>
        </el-form-item>
        <el-form-item label="对齐方式">
          <el-radio-group v-model="formSetting.labelPosition" size="small">
            <el-radio-button label="left">左对齐</el-radio-button>
            <el-radio-button label="right">右对齐</el-radio-button>
            <el-radio-button label="top">顶部对齐</el-radio-button>
          </el-radio-group>
        </el-form-item>
        <el-form-item label="行内表单">
          <el-switch v-model="formSetting.inline" active-color="#13ce66" inactive-color="#ff4949"></el-switch>
        </el-form-item>
      </el-form>
    </div>
    <el-button @click="showDialog()">侧边弹窗</el-button>
    <el-button @click="showDialogTable()">侧边弹窗 table布局</el-button>
    <el-divider />
    <ht-sidebar-dialog
      :width="dialogWidthPrecent"
      title="侧边弹窗例子-添加角色"
      :visible.sync="dialogVisible"
      :before-close="handleClose"
    >
      <el-form
        data-vv-scope="editRoleForm"
        :model="form"
        :label-position="formSetting.labelPosition"
        size="mini"
        :inline="formSetting.inline"
      >
        <ht-form-item label-width="80px">
          <template slot="label">
            <el-popover
              placement="top-start"
              title="标题"
              width="200"
              trigger="hover"
              content="这是一段内容,这是一段内容,这是一段内容,这是一段内容。"
            >
              <span slot="reference">角色名称</span>
            </el-popover>
          </template>

          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="使用自定义的冒号:" label-width="80px" custom-colon>
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'alias': 0, 'value':'禁用'},{'alias': 1, 'value':'启用'}]"
            :props="{key:'alias',value:'value'}"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="性别" label-width="80px">
          <ht-radio
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
        <ht-form-item label="角色名称" label-width="80px">
          <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色别名" label-width="80px">
          <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
        </ht-form-item>
        <ht-form-item label="角色状态" label-width="80px">
          <ht-select
            v-model="form.status"
            :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
            :validate="{'required':true}"
          />
        </ht-form-item>
      </el-form>
      <div slot="footer" class="dialog-footer">
        <el-button @click="dialogCancle">取 消</el-button>
        <el-button type="primary" @click="dialogSave">保 存</el-button>
        <ht-save-button
          scope-name="editRoleForm"
          :is-submit="isSubmit"
          @before-save-data="beforeSaveData"
        >HtSaveButton</ht-save-button>
        <el-button @click="showDialog2()">侧边嵌套弹窗2</el-button>
      </div>
      <div slot="title">
        <span style="color:red;">我是slot标题，会覆盖title中的设置</span>
      </div>

      <ht-sidebar-dialog
        :width="dialogWidthPrecent2"
        title="侧边弹窗例子-添加角色"
        :visible="dialogVisible2"
        :before-close="handleClose2"
        append-to-body
      >
        <el-form :model="form">
          <ht-form-item label="角色名称" label-width="80px">
            <ht-input v-model="form.roleName" autocomplete="off" :validate="{required:true}"></ht-input>
          </ht-form-item>
          <ht-form-item label="角色别名" label-width="80px">
            <ht-input v-model="form.roleCode" autocomplete="off" validate="required"></ht-input>
          </ht-form-item>
          <ht-form-item label="角色状态" label-width="80px">
            <ht-select
              v-model="form.status"
              :options="[{'key': 0, 'value':'禁用'},{'key': 1, 'value':'启用'}]"
              :validate="{'required':true}"
            />
          </ht-form-item>
        </el-form>
        <div slot="footer" class="dialog-footer">
          <el-button @click="dialogVisible2 = false">取 消</el-button>
          <el-button type="primary" @click="dialogVisible2 = false">保 存</el-button>
        </div>
      </ht-sidebar-dialog>
    </ht-sidebar-dialog>

    <ht-sidebar-dialog
      :width="dialogWidthPrecent"
      title="侧边弹窗例子-添加用户"
      :visible.sync="dialogVisible3"
      :before-close="handleClose3"
    >
      <form data-vv-scope="editUserForm">
        <table class="form-table" cellspacing="0" cellpadding="0" border="0">
          <tbody>
            <tr>
              <th width="120px" class="is-required">用户名称:</th>
              <td>
                <ht-input v-model="user.fullname" autocomplete="off" :validate="{required:true}"></ht-input>
              </td>
              <th width="120px" class="is-required">用户账号:</th>
              <td>
                <ht-input v-model="user.account" autocomplete="off" :validate="{required:true}"></ht-input>
              </td>
            </tr>
            <tr>
              <th width="120px">用户性别:</th>
              <td>
                <ht-radio
                  v-model="user.sex"
                  :options="[{key:'1',value:'男士'},{key:'0',value:'女士'}]"
                />
              </td>
              <th width="120px">手机号码:</th>
              <td>
                <ht-input v-model="user.mobile" autocomplete="off" :validate="{mobile:true}"></ht-input>
              </td>
            </tr>
          </tbody>
        </table>
      </form>
      <div slot="footer" class="dialog-footer">
        <el-button @click="dialogCancle">取 消</el-button>
        <el-button type="primary" @click="dialogSave">保 存</el-button>
        <ht-save-button
          scope-name="editUserForm"
          :is-submit="isSubmit"
          @before-save-data="beforeSaveData"
        >HtSaveButton</ht-save-button>
      </div>
      <div slot="title">
        <span style="color:red;">我是slot标题，会覆盖title中的设置</span>
      </div>
    </ht-sidebar-dialog>
  </div>
</template>
<script>
import utils from "@/utils.js";
export default {
  name: "sidebar-dialog-code",
  components: {},
  computed: {
    dialogWidthPrecent: function() {
      return this.formSetting.dialogWidth + "%";
    },
    dialogWidthPrecent2: function() {
      return this.formSetting.dialogWidth - 10 + "%";
    }
  },
  data() {
    return {
      dialogVisible: false,
      dialogVisible2: false,
      dialogVisible3: false,
      form: {},
      user: {},
      formSetting: {
        dialogWidth: 50,
        labelPosition: "left",
        inline: true
      },
      isSubmit: true
    };
  },
  mounted(){
    console.log([{id:'1',name:'苹果'},{id:'2',name:'香蕉'}].extractByKey("id"))
  },
  methods: {
    handleClose() {
      this.dialogVisible = false;
    },
    showDialog() {
      this.dialogVisible = true;
    },
    showDialogTable() {
      this.dialogVisible3 = true;
    },
    handleClose2() {
      this.dialogVisible2 = false;
    },
    handleClose3() {
      this.dialogVisible3 = false;
    },
    showDialog2() {
      this.dialogVisible2 = true;
    },
    dialogCancle() {
      this.$message({
        showClose: true,
        message: "您点击了取消"
      });
      this.dialogVisible = false;
      this.dialogVisible3 = false;
    },
    dialogSave() {
      this.$message({
        showClose: true,
        message: "您点击了保存"
      });
      this.dialogVisible = false;
    },
    beforeSaveData() {
      console.log(new Date().getTime());
      for (let i = 0; i < 1000000000; i++) {}
      console.log(new Date().getTime());
      this.isSubmit = false;
      return false;
    }
  }
};
</script>
<style lang="scss" scoped>
.item-label {
  font-size: 12px;
}

div[aria-invalid='true'] >>> .el-input__inner, div[aria-invalid='true'] >>> .el-input__inner:focus {
  border-color: #f56c6c;
}
</style>`
}

export default sidebardialog;